<?php

namespace onespace\widgets\ui\banner\base;

use app\models\User;
use app\models\XrefUserErf;
use onespace\widgets\ui\base\Tools;
use onespace\widgets\ui\ProfilePic;
use Yii;
use yii\base\Widget;

/**
 * Base class for top banners.
 * 
 * @author  Gareth Palmer <gareth@one-space.co.za>
 */

abstract class TopBanner extends Widget {

    use Tools;

    /**
     * OPTIONAL. The header text to place onto the banner.
     * 
     * @var string  $header_text
     * 
     * @access  public
     */

    public string $header_text;

    /**
     * OPTIONAL. The container class or classes to apply to the banner. May also be applied to
     * another non banner div on the page.
     * 
     * @var string  $container_class
     * 
     * @access  public
     */

    public string $container_class;


    /**
     * {@inheritdoc}
     *
     * @return void
     * 
     * @access  public
     */

    public function init(): void {
        parent::init();
        if (isset($this->banner_top)) {
            $view = $this->getView();
            $view->params['padding-top'] = $this->banner_top;
        }
    }


    /**
     * {@inheritdoc}
     * 
     * @return  string
     * 
     * @access  public
     */

    public function run(): string {
        parent::run();
        $bar = "<div class='ui-userinfo-container";
        $view = $this->getView();
        $view->registerCss($this->minify_css(file_get_contents(__DIR__ . '/../css/base.css')));
        $view->registerCss($this->banner_css());
        return $bar;
    }


    /**
     * Draw the profile pic in the larger style.
     * 
     * @return  string
     * 
     * @access  protected
     */

    protected function profile_pic_big(): string {
        $bar = '';
        $bar .= "<div class='profile-pic'>";
        $bar .= ProfilePic::widget(['options' => ['class' => 'profile-pic-img']]);
        $bar .= "</div>"; // profile-pic
        return $bar;
    }


    /**
     * Draw out the standard user info items.
     * 
     * @return  string
     * 
     * @access  protected
     */

    protected function user_info(): string {
        $inConnect = Yii::$app->session->get('IN_CONNECT', false);
        $profile = $this->get_profile();
        // $erf = $this->get_user_erf();
        $bar = '';
        $bar .= "<div class='profile-info'>";
        $bar .= "<div class='profile-info-sub'>";

        $bar .= "<div><h3 class='h3'>{$profile['name']}&nbsp;";
        if (!$inConnect) {
            $bar .= "<a href='/user/settings/profile' title='Edit my profile' class='profile-link'><i class='far fa-user-edit'></i></a>";
        }
        $bar .= "</h3></div>";

        /**
         * @todo    Handle multiple estates
         */
        // if (isset($erf[0])) {
        //     $bar .= "<div>{$erf[0]['estate']}</div>";
        //     $bar .= "<div>{$erf[0]['address']}</div>";
        // }
        $bar .= "<div>" . Yii::$app->format->phone($profile['phone_number'] ?? '') . "</div>";
        $bar .= "<div>{$profile['email']}</div>";

        $bar .= '</div>'; // profile-info-sub
        $bar .= "</div>"; // profile-info
        return $bar;
    }


    /**
     * Get the user profile information.
     * 
     * @return  array
     * 
     * @access  protected
     */

    protected function get_profile(): array {
        return User::find()
            ->select([
                'user.username as username',
                'user.email as email',
                'profile.name as name',
                'profile.public_email as public_email',
                'profile.phone_number as phone_number',
            ])
            ->innerJoin('profile', 'user.id = profile.user_id')
            ->where(['user.id' => Yii::$app->user->id])
            ->asArray()
            ->one();
    }


    /**
     * Get user ERF info.
     * 
     * @return  array
     * 
     * @access  protected
     */

    protected function get_user_erf(): array {
        return XrefUserErf::find()
            ->select([
                'estate.name as estate',
                'xref_user_erf.address',
            ])
            ->innerJoin('erf', 'xref_user_erf.erf_id = erf.id')
            ->innerJoin('estate', 'erf.estate_id = estate.id')
            ->where(['user_id' => Yii::$app->user->id])
            ->asArray()
            ->all();
    }
}
