<?php

namespace onespace\widgets\icons\base;

use yii\bootstrap\Widget;

/**
 * Base widget generation class, with common properties across the icon widgets.
 * 
 * @author  Jason Phillips <jason@one-space.co.za>
 */

abstract class Icon extends Widget {

    protected string $baseClass;
    protected string $defaultIdentifier;

    private const VALID_COLOURS = [
        'light-blue',
        'aqua',
        'green',
        'yellow',
        'red',
        'gray',
        'navy',
        'teal',
        'purple',
        'orange',
        'maroon',
        'black'
    ];

    public ?string $colour = null;
    public ?string $identifier = null;
    public string $content = '&nbsp;';

    private string $colourClass = '';


    /**
     * {@inheritdoc}
     */

    public function init() {
        parent::init();

        if ($this->colour != null) {
            if (in_array($this->colour, self::VALID_COLOURS)) {
                $this->colourClass = ' text-' . $this->colour;
            }
        }

        if ($this->identifier == null) {
            $this->identifier = $this->defaultIdentifier;
        }
    }


    /**
     * {@inheritdoc}
     */

    public function run() {
        // If user has configured the class option, add those classes to the required ones
        $appendClass = isset($this->options['class']) ? ' ' . $this->options['class'] : '';
        $this->options['class'] = $this->baseClass . $this->identifier . $this->colourClass . $appendClass;
        return \yii\helpers\Html::tag(
            'i',
            $this->content,
            $this->options
        );
    }
}
