<?php

namespace onespace\widgets\icons;

use onespace\widgets\icons\base\FAHelper;
use onespace\widgets\icons\base\Icon;


/**
 * Generate FontAwesome 6 library icons as a widget.
 * 
 * To use this widget, you need to register `\onespace\widgets\icons\assets\FontAwesome6Asset::class` in `AppAssets`.
 * 
 * @property    string|null $identifier See `https://fontawesome.com/icons`
 * @property    string|null $style
 * ## Valid Style Options
 * - solid
 * - regular
 * - light
 * - duotone
 * - thin
 * - brand (Only available for a small number of icons)
 * @property    string|null $colour
 * ## Valid Colour Options
 * - light-blue
 * - aqua
 * - green
 * - yellow
 * - red
 * - gray
 * - navy
 * - teal
 * - purple
 * - orange
 * - maroon
 * - black
 * @property    string  $content    Default: `&nbsp;`
 * 
 * @author  Gareth Palmer   <gareth@one-space.co.za>
 */

final class FontAwesomeIcon6 extends Icon {

    use FAHelper;

    protected const STYLES = [
        'solid' => 'fa-solid',
        'regular' => 'fa-regular',
        'light' => 'fa-light',
        'duotone' => 'fa-duotone',
        'thin' => 'fa-thin',
        'brand' => 'fa-brands'
    ];
}
