<?php

namespace onespace\tools\widgets\ui\base;

/**
 * Enum for describing a header alignment.
 * 
 * @author  Gareth Palmer <gareth@one-space.co.za>
 */
enum Align {
    case LEFT;
    case CENTER;
    case RIGHT;

    /**
     * Returns the class to enforce this alignment.
     * 
     * @return  string
     * 
     * @access  public
     */

    public function get_class(): string {
        return match ($this) {
            self::LEFT => 'item-header-left',
            self::CENTER => 'item-header-center',
            self::RIGHT => 'item-header-right',
        };
    }
}
