# EXAMPLES

## PHP Examples

### Common methods used in example

```php
$data = [];
$data2 = [];

for ($i = 1987; $i <= 2024; $i++) {
    $data[] = [
        'year' => $i,
        'count' => random_int(1, 5000),
    ];
    $data2[] = [
        'year' => $i,
        'count' => random_int(1, 5000),
    ];
}

$labels = array_map(function ($data) {
    return $data['year'];
}, $data);
$nums = array_map(function ($data) {
    return $data['count'];
}, $data);
$nums2 = array_map(function ($data) {
    return $data['count'];
}, $data2);

$randomColour = function () {
    return '#' . dechex(random_int(1, 255)) . dechex(random_int(1, 255)) . dechex(random_int(1, 255));
};
```

### Bar Graph

```php
// Bar Graph
echo ChartJs::widget(['data' => [
    'type' => 'bar',
    'options' => [
        'layout' => [
            'padding' => 60
        ]
        // 'animation' => false,
        // 'plugins' => [
        //     'legend' => [
        //         'display' => false
        //     ],
        //     'tooltip' => [
        //         'enabled' => false
        //     ],
        // ]
    ],
    'data' => [
        'labels' => $labels,
        'datasets' => [
            [
                'label' => 'Acquisitions by year',
                'data' => $nums,
                'borderColor' => $randomColour(),
                'backgroundColor' => $randomColour(),
            ],
            [
                'label' => 'Sales by year',
                'data' => $nums2,
                'borderColor' => $randomColour(),
                'backgroundColor' => $randomColour(),
            ],
        ],
    ],
]]);
```

### Line Graph

```php
// Line Graph
echo ChartJs::widget(['data' => [
    'type' => 'line',
    'data' => [
        'labels' => ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul'],
        'datasets' => [
            [
                'label' => 'Basic Line Graph',
                'data' => [
                    random_int(1, 450),
                    random_int(1, 450),
                    random_int(1, 450),
                    random_int(1, 450),
                    random_int(1, 450),
                    random_int(1, 450),
                    random_int(1, 450),
                ],
                'borderColor' => $randomColour(),
                'tension' => 0.1
            ],
            [
                'label' => 'Basic Line Graph',
                'data' => [
                    random_int(1, 450),
                    random_int(1, 450),
                    random_int(1, 450),
                    random_int(1, 450),
                    random_int(1, 450),
                    random_int(1, 450),
                    random_int(1, 450),
                ],
                'borderColor' => $randomColour(),
                'tension' => 0.1
            ],
            [
                'label' => 'Basic Line Graph',
                'data' => [
                    random_int(1, 450),
                    random_int(1, 450),
                    random_int(1, 450),
                    random_int(1, 450),
                    random_int(1, 450),
                    random_int(1, 450),
                    random_int(1, 450),
                ],
                'borderColor' => $randomColour(),
                'tension' => 0.1
            ],
        ]
    ]
]]);
```

### Area Graph

```php
// Area Graph
echo ChartJs::widget(['data' => [
    'type' => 'line',
    'data' => [
        'labels' => ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul'],
        'datasets' => [
            [
                'label' => 'Basic Area Graph',
                'data' => [
                    random_int(1, 450),
                    random_int(1, 450),
                    random_int(1, 450),
                    random_int(1, 450),
                    random_int(1, 450),
                    random_int(1, 450),
                    random_int(1, 450),
                ],
                'borderColor' => $randomColour(),
                'backgroundColor' => $randomColour(). '80',
                'fill' => 'stack',
                'tension' => 0.1
            ],
            [
                'label' => 'Basic Area Graph',
                'data' => [
                    random_int(1, 450),
                    random_int(1, 450),
                    random_int(1, 450),
                    random_int(1, 450),
                    random_int(1, 450),
                    random_int(1, 450),
                    random_int(1, 450),
                ],
                'borderColor' => $randomColour(),
                'backgroundColor' => $randomColour(). '80',
                'fill' => 'stack',
                'tension' => 0.1
            ],
            [
                'label' => 'Basic Area Graph',
                'data' => [
                    random_int(1, 450),
                    random_int(1, 450),
                    random_int(1, 450),
                    random_int(1, 450),
                    random_int(1, 450),
                    random_int(1, 450),
                    random_int(1, 450),
                ],
                'borderColor' => $randomColour(),
                'backgroundColor' => $randomColour(). '80',
                'fill' => 'stack',
                'tension' => '0.1'
            ],
        ]
    ]
]]);
```

## Raw JavaScript Examples

### Live Area Chart, which updates every 1 seecond

```js
// Helper functions
function generateRandomInteger(min, max) {
    return Math.floor(Math.random()(max - min + 1)) + min;
}

function formatTime(date) {
    return `${(date.getHours() < 10 ? '0' : '') + date.getHours()}:${(date.getMinutes() < 10 ? '0' : '') + date.getMinutes()}:${(date.getSeconds() < 10 ? '0' : '') + date.getSeconds()}`;
}

// Initial data
const now = new Date();
const lastThreeMinutesData = [
    {
        time: formatTime(new Date(now.getTime() - 91000)),
        value: generateRandomInteger(1, 100),
    },
    {
        time: formatTime(new Date(now.getTime() - 81000)),
        value: generateRandomInteger(1, 100),
    },
    {
        time: formatTime(new Date(now.getTime() - 71000)),
        value: generateRandomInteger(1, 100),
    },
    {
        time: formatTime(new Date(now.getTime() - 61000)),
        value: generateRandomInteger(1, 100),
    },
    {
        time: formatTime(new Date(now.getTime() - 51000)),
        value: generateRandomInteger(1, 100),
    },
    {
        time: formatTime(new Date(now.getTime() - 41000)),
        value: generateRandomInteger(1, 100),
    },
    {
        time: formatTime(new Date(now.getTime() - 31000)),
        value: generateRandomInteger(1, 100),
    },
    {
        time: formatTime(new Date(now.getTime() - 21000)),
        value: generateRandomInteger(1, 100),
    },
    {
        time: formatTime(new Date(now.getTime() - 11000)),
        value: generateRandomInteger(1, 100),
    },
    {
        time: formatTime(now),
        value: generateRandomInteger(1, 100)
    },
];

// Draw chart
const pt = document.querySelector('#abc')
const chart = new Chart(pt, {
    type: 'line',
    options: {
        elements: {
            line: {
                tension: 0.4
            }
        }
    },
    data: {
        labels: lastThreeMinutesData.map(entry => entry.time),
        datasets: [
            {
                label: 'Over Time',
                data: lastThreeMinutesData.map(entry => entry.value),
                fill: 'start'
            }
        ]
    }
})

// Update every 1 second
let i = 0
setInterval(() => {
    // Skip the first interval
    if (i == 0) {
        i++
        return;
    }

    // Add new data and label
    chart.data.labels.push(formatTime(new Date()));
    chart.data.datasets[0].data.push(generateRandomInteger(1, 100));
    chart.update()

    // If the number of printed of results are greater than 20, 
    // trim the first 10 results.
    if (chart.data.labels.length > 20) {
        for (let i = 0; i < 10; i++) {
            chart.data.labels.shift();
            chart.data.datasets[0].data.shift();
        }
        chart.update()
    }
}, 1000);
```
