<?php

namespace onespace\tools\widgets\ui;

use Exception;
use onespace\tools\widgets\ui\base\ImgBase;

/**
 * Draws the estate logo.
 * 
 * @author  Gareth Palmer <gareth@one-space.co.za>
 */

class EstateLogo extends ImgBase {

    /**
     * REQUIRED. The id of the estate, who's logo you want.
     * 
     * @var integer $id
     * 
     * @access  public
     */

    public int $id;

    /**
     * The base uri for getting logos from absolute paths.
     * 
     * @var string  URI
     * 
     * @access  public
     */

    const URI = '/estate/logo?id=';


    /**
     * @inheritdoc
     * 
     * @throws  Exception   If no id set
     * 
     * @return  string
     */

    public function run(): string {
        parent::run();

        if (!isset($this->id)) {
            throw new Exception("No id set. Please set an id");
        }

        return $this->createImgHtml(self::URI . $this->id);
    }
}
