<?php

namespace onespace\tools\helpers\traits;

use Exception;
use PhpOffice\PhpSpreadsheet\IOFactory;
use PhpOffice\PhpSpreadsheet\Reader\IReader;

trait ExcelLoader {

    public function getExcelObjectFromFile(string $file, $memoryLimit = '128M'): IReader {
        ini_set('memory_limit', $memoryLimit);
        if (!file_exists($file)) {
            echo "File \"{$file}\" does not exist or is not available.\n";
            exit(1);
        }
        try {
            // $inputFileType = IOFactory::identify($file);
            $objReader = IOFactory::createReader(IOFactory::identify($file));
            return $objReader->load($file);
        } catch (Exception $e) {
            echo "\n";
            print_r($e);
            echo "\n";
            exit(1);
        }
    }
}
