<?php

namespace onespace\tools\helpers\enum;

/**
 * Enum for listing Bootstrap (5) style colouring.
 * 
 * @see https://getbootstrap.com/docs/5.3/customize/color/
 */
enum Style {
    /**
     * Typically blue.
     */
    case PRIMARY;
    /**
     * Typically grey.
     */
    case SECONDARY;
    /**
     * Typically green.
     */
    case SUCCESS;
    /**
     * Typically red.
     */
    case DANGER;
    /**
     * Typically orange / yellow.
     */
    case WARNING;
    /**
     * Typically light blue.
     */
    case INFO;
    /**
     * Typically white.
     */
    case LIGHT;
    /**
     * Typically black.
     */
    case DARK;
    /**
     * Typically styled as a link.
     */
    case LINK;

    /**
     * @see https://primereact.org/toast/#severity
     */
    case PRIME_SUCCESS;
    /**
     * @see https://primereact.org/toast/#severity
     */
    case PRIME_INFO;
    /**
     * @see https://primereact.org/toast/#severity
     */
    case PRIME_WARN;
    /**
     * @see https://primereact.org/toast/#severity
     */
    case PRIME_ERROR;
    /**
     * @see https://primereact.org/toast/#severity
     */
    case PRIME_SECONDARY;
    /**
     * @see https://primereact.org/toast/#severity
     */
    case PRIME_CONTRAST;


    public function id(): string {
        return match ($this) {
            self::PRIMARY   => 'primary',
            self::SECONDARY => 'secondary',
            self::SUCCESS   => 'success',
            self::DANGER    => 'danger',
            self::WARNING   => 'warning',
            self::INFO      => 'info',
            self::LIGHT     => 'light',
            self::DARK      => 'dark',
            self::LINK      => 'link',

            self::PRIME_SUCCESS   => 'success',
            self::PRIME_INFO      => 'info',
            self::PRIME_WARN      => 'warn',
            self::PRIME_ERROR     => 'error',
            self::PRIME_SECONDARY => 'secondary',
            self::PRIME_CONTRAST  => 'contrast',
        };
    }


    private static function bootstrapStyles(): array {
        return [
            self::PRIMARY,
            self::SECONDARY,
            self::SUCCESS,
            self::DANGER,
            self::WARNING,
            self::INFO,
            self::LIGHT,
            self::DARK,
            self::LINK,
        ];
    }


    private static function primeStyles(): array {
        return [
            self::PRIME_SUCCESS,
            self::PRIME_INFO,
            self::PRIME_WARN,
            self::PRIME_ERROR,
            self::PRIME_SECONDARY,
            self::PRIME_CONTRAST,
        ];
    }


    public function isBootstrap(): bool {
        return in_array($this, self::bootstrapStyles());
    }

    public function isPrime(): bool {
        return in_array($this, self::primeStyles());
    }
}
