<?php

namespace onespace\tools\widgets\ui\banner;

use onespace\tools\widgets\ui\banner\base\BannerTemplate;
use onespace\tools\widgets\ui\banner\base\TopBanner;

/**
 * Draw the top wide banner. It contains user's personal information with wide margins.
 */

final class BannerWideUserInfo extends TopBanner implements BannerTemplate {

    /**
     * The gap between the banner and main content
     *
     * @var string  $banner_top     Default: 3.5rem
     * 
     * @access  public
     */

    public string $banner_top = '2.7rem';


    /**
     * {@inheritdoc}
     * 
     * @return string
     * 
     * @access  public
     */

    public function run(): string {
        $bar = parent::run();
        $bar .= ' ui-panel general-wide-banner';
        if (isset($this->container_class)) {
            $bar .= " {$this->container_class}";
        }
        if (!isset($this->header_text)) {
            $bar .= " no-header";
        }
        $bar .= " rp-heading'>";
        if (isset($this->header_text)) {
            $bar .= "<h2 class='h2'>{$this->header_text}</h2>";
        }
        $bar .= $this->profile_pic_big();
        $bar .= $this->user_info();
        $bar .= "</div>"; // ui-userinfo-container
        return $bar;
    }


    /**
     * {@inheritdoc}
     * 
     * @return string
     * 
     * @access  public
     */

    public function banner_css(): string {
        return $this->minifyCss(file_get_contents(__DIR__ . '/css/wide-user-info.css'));
    }
}
