<?php

namespace onespace\tools\widgets\icons;

use onespace\tools\helpers\enum\UnbackedHelper;

/**
 * Defined OS Icons used for various things in the context of various OS webpages.
 * 
 * @author  Gareth Palmer <gareth@one-space.co.za>
 */
enum OSIcon {

    use UnbackedHelper;

    /** Connect Only */
    case ABOUT_INFO;
    /** OneAccess Icon */
    case ACCESS_CONTROL_EVENTS;
    case ACCESS_CONTROL;
    case ACCESS_DEVICE_BIOMETRIC;
    case ACCESS_DEVICE_FACE;
    case ACCESS_DEVICE_FINGERPRINT;
    case ACCESS_DEVICE_RFID_UHF;
    case ACCESS_DEVICE_SHERLO_CODEHOP;
    case ACCESS_DEVICE_SHERLO_BLUETOOTH;
    case ACCESS_DEVICE_SHERLO_VEHICLE;
    case ACCESS_DEVICES;
    case ACCESS_LOCATIONS;
    case ACCESS_POINT;
    case ACCESS_TIMES;
    case ACTION_CENTER_ACTIVE;
    /** Same as 'SNIPR Notifications' */
    case ACTION_CENTER_INACTIVE;
    case ACTION_SNOOZE;
    case ADD;
    /** Same as 'Verified' */
    case AUTHORISATIONS;
    /** Ideally use custom version */
    case BESECURE_WEARABLE;
    /** 
     * Awaiting SIG Verification
     * @deprecated 
     */
    case BLUETOOTH;
    case BOOKING_APPROVE;
    case BOOKING_DENY_DELETE;
    case BOOKING_EDIT;
    case BOOKING_NEW;
    case BOOKINGS;
    case CLUB;
    case COMMS_ANNOUNCEMENTS;
    case COMMS_INBOX;
    case COMMS_MESSAGES;
    /** @deprecated */
    case COMMS_NEWS;
    /** Connect Icon */
    case CONNECT_APP;
    case CONNECT_PANIC;
    case CONTRACTOR_COMPANY;
    case CONTRACTOR_TEAM;
    case CONTRACTOR_USER;
    case DELETE;
    case DENY;
    case DEVICE_HEALTH;
    case DOCUMENTS;
    case CONTACT_EMAIL;
    /** @deprecated */
    case ENTROLMENTS;
    case EVENTS;
    /** Same as 'Property - Facility' */
    case FACILTY;
    case FACILITY_BOOKING;
    case FINANCE;
    case FOLDER_ADD;
    /** GateBook Icon */
    case GATEBOOK;
    case GATEBOOK_WORKFLOW;
    case HELP_FAQ;
    case HISTORY;
    case INCIDENT_CRIME;
    case INCIDENT_ELECTRICTIY;
    case INCIDENT_INTERNET;
    case INCIDENT_OTHER;
    case INCIDENT_PARKS;
    /** Incidents */
    case INCIDENT_REPORTING;
    case INCIDENT_ROAD;
    case INCIDENT_SEWAGE;
    case INCIDENT_WATER;
    case LOGOUT;
    case MEMBERSHIPS;
    case NOTE;
    case OWNERSHIP;
    case PET_AMPHIBIAN;
    case PET_BIRD;
    case PET_CAT;
    case PET_DOG;
    case PET_FISH;
    case PET_LIZARD;
    case PET_OTHER;
    case PET_RABBIT;
    case PET_REPTILE;
    case PET_RODENT;
    case PET_SNAKE;
    case PETS;
    case CONTACT_PHONE_NUMBER;
    case PIN;
    case PRIMARY_CONTACT;
    /** Ideally Use 1iD */
    case PROFILE;
    case PROPERTY_HOUSE;
    case PROPERTY_BUILDING;
    case PROPERTY_BUSINESS;
    case PROPERTY_BUSINESS_PARK;
    /** Same as 'Visited Property' */
    case PROPERTY_DESTINATION;
    case PROPERTY_ERF_STAND;
    /** Same as 'Facility' */
    case PROPERTY_FACILITY;
    case PROPERTY_NEIGHBORHOOD_WATCH;
    case PROPERTY_RESIDENTIAL_ESTATE;
    case PROPERTY_STREET;
    case PROPERTY_UNIT;
    case PROPERTY_ZONE;
    /** @deprecated */
    case PROPERTY;
    case PROPERTIES;
    case RECENT_ACTIVITY;
    case REGISTER;
    case RELATIONSHIP;
    case RELATIONSHIP_DEPENDANT;
    case RESIDENT_PORTAL;
    /** Central Icon */
    case SAVE_APPROVE;
    case SELECT_ALL;
    case SELECT_DATE_SINGLE;
    case SELECT_DATES_DURATION;
    case SELECT_INVERT_SELECTION;
    case SELECT_UNSELECT_ALL;
    case SETTINGS;
    case SIGN_IN;
    case SIGN_OUT;
    case SITE_CONTACTS;
    case SITES;
    case SMS_CREDITS;
    case SMSS_FAILED;
    case SMSS_SENT;
    /** Possible clash with 'SNIPR Incident Details' */
    case SNIPR_ALERT_DETAILS;
    case SNIPR_ALERTS;
    /** SNIPR Icon */
    case SNIPR_CAMERAS;
    /** Replacing 'SNIPR Area/Areas' */
    case SNIPR_COMPANY;
    case SNIPR_DASHBOARD;
    case SNIPR_HOTLIST;
    /** Possible clash with 'SNIPR Alert Details' */
    case SNIPR_INCDENT_DETAILS;
    case SNIPR_LOOKUP_SEARCH;
    case SNIPR_MAP;
    /** Same as 'Action Centre Inactive' */
    case SNIPR_NOTIFICATIONS;
    /** @deprecated */
    case SNIPR_AREA;
    /** @deprecated */
    case SNIPR_AREAS;
    case SNIPR_PATROL_USERS;
    case SNIPR_CEHICLE_DETAILS;
    case STAFF;
    case STAT_DECREASE;
    case STAT_GRAPH;
    case STAT_INCREASE;
    case SYSTEM_COMMAND;
    case TERMS_CONDITIONS;
    case UNDO;
    /** @deprecated */
    case UNIT;
    case USER_ADD;
    case USER_APPROVE;
    case USER_DENY;
    case USER_REMOVE;
    case USER_SUSPEND;
    /** 1iD Linked vehicle */
    case VEHICLE;
    case VEHICLES;
    /** Same as 'Authorisations' */
    case VERIFIED;
    case VIEW;
    /** Same as 'Property - Destination' */
    case VISITED_PROPERTY;
    /** Visitor Centre */
    case VISITORS;
    case BESECURE_STATUS_NORMAL;
    case BESECURE_STATUS_AWAITING_MANUAL_TEST;
    case BESECURE_STATUS_SNOOZED;
    case BESECURE_STATUS_PARKED;
    case BESECURE_STATUS_OFFLINE;
    case REPORTS;
    case SURVEYS_POLLS;
    case OS_TECH_TIP;


    /**
     * Return the FA ID of the specified enum.
     * 
     * @return  string
     * 
     * @access  public
     */

    public function id(): string {
        return $this->data('id');
    }


    /**
     * Return the name of the OS Name of the specified enum.
     * 
     * @return  string
     * 
     * @access  public
     */

    public function name(): string {
        return $this->data('name');
    }


    /**
     * Returns the svg code of the specified enum.
     * 
     * @return  string
     * 
     * @access  public
     */

    public function code(): string {
        return $this->data('code');
    }


    /**
     * The relevant data for each enum.
     * 
     * @param   string  $id The type of data to be returned (`id`, `name`, or `code`)
     * 
     * @return  string
     * 
     * @access  private
     */

    private function data(string $id): string {
        return match ($this) {
            self::ABOUT_INFO => [
                'id' => 'square-info',
                'name' => 'About/Info',
                'code' => 'f30f',
            ][$id],
            self::ACCESS_CONTROL_EVENTS => [
                'id' => 'lock-open',
                'name' => 'Access Control Events',
                'code' => 'f3c1',
            ][$id],
            self::ACCESS_CONTROL => [
                'id' => 'lock',
                'name' => 'Access Control',
                'code' => 'f023',
            ][$id],
            self::ACCESS_DEVICE_BIOMETRIC => [
                'id' => 'universal-access',
                'name' => 'Access Device - Biometric',
                'code' => 'f29a',
            ][$id],
            self::ACCESS_DEVICE_FACE => [
                'id' => 'face-viewfinder',
                'name' => 'Access Device - Face',
                'code' => 'e2ff',
            ][$id],
            self::ACCESS_DEVICE_FINGERPRINT => [
                'id' => 'fingerprint',
                'name' => 'Access Device - Fingerprint',
                'code' => 'f577',
            ][$id],
            self::ACCESS_DEVICE_RFID_UHF => [
                'id' => 'square-rss',
                'name' => 'Access Device - RFID/UHF',
                'code' => 'f143',
            ][$id],
            self::ACCESS_DEVICE_SHERLO_CODEHOP => [
                'id' => 'traffic-light',
                'name' => 'Access Device - Sherlo/Codehop',
                'code' => 'f637',
            ][$id],
            self::ACCESS_DEVICE_SHERLO_BLUETOOTH => [
                'id' => 'mobile-signal-out',
                'name' => 'Access Device - Bluetooth',
                'code' => 'e1f0',
            ][$id],
            self::ACCESS_DEVICE_SHERLO_VEHICLE => [
                'id' => 'car-rear',
                'name' => 'Access Device - Vehicle',
                'code' => 'f5de',
            ][$id],
            self::ACCESS_DEVICES => [
                'id' => 'key',
                'name' => 'Access Devices',
                'code' => 'f084',
            ][$id],
            self::ACCESS_LOCATIONS => [
                'id' => 'location-check',
                'name' => 'Access Locations',
                'code' => 'f606',
            ][$id],
            self::ACCESS_POINT => [
                'id' => 'door-open',
                'name' => 'Access Point',
                'code' => 'f52b',
            ][$id],
            self::ACCESS_TIMES => [
                'id' => 'timer',
                'name' => 'Access Times',
                'code' => 'e29e',
            ][$id],
            self::ACTION_CENTER_ACTIVE => [
                'id' => 'bell-on',
                'name' => 'Action Centre Active',
                'code' => 'f8fa',
            ][$id],
            self::ACTION_CENTER_INACTIVE => [
                'id' => 'bell',
                'name' => 'Action Centre Inactive',
                'code' => 'f0f3',
            ][$id],
            self::ACTION_SNOOZE => [
                'id' => 'alarm-snooze',
                'name' => 'Action Snooze',
                'code' => 'f845',
            ][$id],
            self::ADD => [
                'id' => 'cloud-plus',
                'name' => 'Add',
                'code' => 'e35e',
            ][$id],
            self::AUTHORISATIONS => [
                'id' => 'check-circle',
                'name' => 'Authorisations',
                'code' => 'f058',
            ][$id],
            self::BESECURE_WEARABLE => [
                'id' => 'watch-fitness',
                'name' => 'BeSecure Wearable',
                'code' => 'f63e',
            ][$id],
            self::BLUETOOTH => [
                'id' => 'bluetooth',
                'name' => 'Bluetooth',
                'code' => 'f293',
            ][$id],
            self::BOOKING_APPROVE => [
                'id' => 'calendar-check',
                'name' => 'Booking Approve',
                'code' => 'f274',
            ][$id],
            self::BOOKING_DENY_DELETE => [
                'id' => 'calendar-xmark',
                'name' => 'Booking Deny/Delete',
                'code' => 'f273',
            ][$id],
            self::BOOKING_EDIT => [
                'id' => 'calendar-pen',
                'name' => 'Booking Edit',
                'code' => 'f333',
            ][$id],
            self::BOOKING_NEW => [
                'id' => 'calendar-plus',
                'name' => 'Booking New',
                'code' => 'f271',
            ][$id],
            self::BOOKINGS => [
                'id' => 'calendar-day',
                'name' => 'Bookings',
                'code' => 'f783',
            ][$id],
            self::CLUB => [
                'id' => 'circle-star',
                'name' => 'Club',
                'code' => 'e123',
            ][$id],
            self::COMMS_ANNOUNCEMENTS => [
                'id' => 'megaphone',
                'name' => 'Comms - Announcements',
                'code' => 'f675',
            ][$id],
            self::COMMS_INBOX => [
                'id' => 'mailbox',
                'name' => 'Comms - Inbox',
                'code' => 'f813',
            ][$id],
            self::COMMS_MESSAGES => [
                'id' => 'envelope',
                'name' => 'Comms - Messages',
                'code' => 'f0e0',
            ][$id],
            self::COMMS_NEWS => [
                'id' => 'newspaper',
                'name' => 'Comms - News',
                'code' => 'f1ea',
            ][$id],
            self::CONNECT_APP => [
                'id' => 'mobile-button',
                'name' => 'Connect App',
                'code' => 'f10b',
            ][$id],
            self::CONNECT_PANIC => [
                'id' => 'circle-exclamation',
                'name' => 'Connect Panic',
                'code' => 'f06a',
            ][$id],
            self::CONTRACTOR_COMPANY => [
                'id' => 'people-carry-box',
                'name' => 'Contractor - Company',
                'code' => 'f4ce',
            ][$id],
            self::CONTRACTOR_TEAM => [
                'id' => 'screen-users',
                'name' => 'Contractor - Team',
                'code' => 'f63d',
            ][$id],
            self::CONTRACTOR_USER => [
                'id' => 'person-carry-box',
                'name' => 'Contractor - User',
                'code' => 'f4cf',
            ][$id],
            self::DELETE => [
                'id' => 'trash-can',
                'name' => 'Delete',
                'code' => 'f2ed',
            ][$id],
            self::DENY => [
                'id' => 'cloud-xmark',
                'name' => 'Deny',
                'code' => 'e35f',
            ][$id],
            self::DEVICE_HEALTH => [
                'id' => 'heartbeat',
                'name' => 'Device Health',
                'code' => 'f21e',
            ][$id],
            self::DOCUMENTS => [
                'id' => 'cabinet-filing',
                'name' => 'Documents',
                'code' => 'f64b',
            ][$id],
            self::CONTACT_EMAIL => [
                'id' => 'at',
                'name' => 'Contact - Email ',
                'code' => '40',
            ][$id],
            self::ENTROLMENTS => [
                'id' => 'square-pen',
                'name' => 'Enrolments',
                'code' => 'f14b',
            ][$id],
            self::EVENTS => [
                'id' => 'calendar-star',
                'name' => 'Events',
                'code' => 'f736',
            ][$id],
            self::FACILTY => [
                'id' => 'school',
                'name' => 'Facility',
                'code' => 'f549',
            ][$id],
            self::FACILITY_BOOKING => [
                'id' => 'caledar-day',
                'name' => 'Facility Booking',
                'code' => 'f783',
            ][$id],
            self::FINANCE => [
                'id' => 'piggy-bank',
                'name' => 'Finance',
                'code' => 'f4d3',
            ][$id],
            self::FOLDER_ADD => [
                'id' => 'folder-plus',
                'name' => 'Folder Add',
                'code' => 'f65e',
            ][$id],
            self::GATEBOOK => [
                'id' => 'scanner-touchscreen',
                'name' => 'GateBook',
                'code' => 'f48a',
            ][$id],
            self::GATEBOOK_WORKFLOW => [
                'id' => 'list-timeline',
                'name' => 'GateBook Workflow',
                'code' => 'e1d1',
            ][$id],
            self::HELP_FAQ => [
                'id' => 'circle-question',
                'name' => 'Help/FAQ',
                'code' => 'f059',
            ][$id],
            self::HISTORY => [
                'id' => 'clock-rotate-left',
                'name' => 'History',
                'code' => 'f1da',
            ][$id],
            self::INCIDENT_CRIME => [
                'id' => 'luchador',
                'name' => 'Incident - Crime',
                'code' => 'f455',
            ][$id],
            self::INCIDENT_ELECTRICTIY => [
                'id' => 'lightbulb-exclamation',
                'name' => 'Incident - Electricity',
                'code' => 'f671',
            ][$id],
            self::INCIDENT_INTERNET => [
                'id' => 'wifi-exclamation',
                'name' => 'Incident - Internet',
                'code' => 'e2cf',
            ][$id],
            self::INCIDENT_OTHER => [
                'id' => 'exclamation-triangle',
                'name' => 'Incident - Other',
                'code' => 'f071',
            ][$id],
            self::INCIDENT_PARKS => [
                'id' => 'bench-tree',
                'name' => 'Incident - Parks',
                'code' => 'e2e7',
            ][$id],
            self::INCIDENT_REPORTING => [
                'id' => 'map-marker-exclamation',
                'name' => 'Incident - Reporting',
                'code' => 'f608',
            ][$id],
            self::INCIDENT_ROAD => [
                'id' => 'road-circle-exclamation',
                'name' => 'Incident - Road',
                'code' => 'e565',
            ][$id],
            self::INCIDENT_SEWAGE => [
                'id' => 'manhole',
                'name' => 'Incident - Sewage',
                'code' => 'e1d6',
            ][$id],
            self::INCIDENT_WATER => [
                'id' => 'faucet-drip',
                'name' => 'Incident - Water',
                'code' => 'e006',
            ][$id],
            self::LOGOUT => [
                'id' => 'right-from-bracket',
                'name' => 'Logout',
                'code' => 'f2f5',
            ][$id],
            self::MEMBERSHIPS => [
                'id' => 'stars',
                'name' => 'Memberships',
                'code' => 'f762',
            ][$id],
            self::NOTE => [
                'id' => 'notes',
                'name' => 'Note',
                'code' => 'e202',
            ][$id],
            self::OWNERSHIP => [
                'id' => 'hand-holding-box',
                'name' => 'Ownership',
                'code' => 'f47b',
            ][$id],
            self::PET_AMPHIBIAN => [
                'id' => 'frog',
                'name' => 'Pet - Amphibian',
                'code' => 'f52e',
            ][$id],
            self::PET_BIRD => [
                'id' => 'dove',
                'name' => 'Pet - Bird',
                'code' => 'f4ba',
            ][$id],
            self::PET_CAT => [
                'id' => 'cat',
                'name' => 'Pet - Cat',
                'code' => 'f6be',
            ][$id],
            self::PET_DOG => [
                'id' => 'dog',
                'name' => 'Pet - Dog',
                'code' => 'f6d3',
            ][$id],
            self::PET_FISH => [
                'id' => 'fish',
                'name' => 'Pet - Fish',
                'code' => 'f578',
            ][$id],
            self::PET_LIZARD => [
                'id' => 'dragon',
                'name' => 'Pet - Lizard',
                'code' => 'f6d5',
            ][$id],
            self::PET_OTHER => [
                'id' => 'unicorn',
                'name' => 'Pet - Other',
                'code' => 'f727',
            ][$id],
            self::PET_RABBIT => [
                'id' => 'rabbit',
                'name' => 'Pet - Rabbit',
                'code' => 'f708',
            ][$id],
            self::PET_REPTILE => [
                'id' => 'turtle',
                'name' => 'Pet - Reptile',
                'code' => 'f726',
            ][$id],
            self::PET_RODENT => [
                'id' => 'squirrel',
                'name' => 'Pet - Rodent',
                'code' => 'f71a',
            ][$id],
            self::PET_SNAKE => [
                'id' => 'snake',
                'name' => 'Pet - Snake',
                'code' => 'f716',
            ][$id],
            self::PETS => [
                'id' => 'paw',
                'name' => 'Pets',
                'code' => 'f1b0',
            ][$id],
            self::CONTACT_PHONE_NUMBER => [
                'id' => 'circle-phone',
                'name' => 'Contact - Phone Number',
                'code' => 'e11b',
            ][$id],
            self::PIN => [
                'id' => 'lock-hashtag',
                'name' => 'PIN',
                'code' => 'e423',
            ][$id],
            self::PRIMARY_CONTACT => [
                'id' => 'house-user',
                'name' => 'Primary Contact',
                'code' => 'e1b0',
            ][$id],
            self::PROFILE => [
                'id' => 'user-cog',
                'name' => 'Profile',
                'code' => 'f4fe',
            ][$id],
            self::PROPERTY_HOUSE => [
                'id' => 'house',
                'name' => 'Property -  House',
                'code' => 'f015',
            ][$id],
            self::PROPERTY_BUILDING => [
                'id' => 'building',
                'name' => 'Property - Building',
                'code' => 'f1ad',
            ][$id],
            self::PROPERTY_BUSINESS => [
                'id' => 'briefcase',
                'name' => 'Property - Business',
                'code' => 'f0b1',
            ][$id],
            self::PROPERTY_BUSINESS_PARK => [
                'id' => 'buildings',
                'name' => 'Property - Business Park',
                'code' => 'e0cc',
            ][$id],
            self::PROPERTY_DESTINATION => [
                'id' => 'house-person-return',
                'name' => 'Property - Destination',
                'code' => 'e011',
            ][$id],
            self::PROPERTY_ERF_STAND => [
                'id' => 'frame',
                'name' => 'Property - Erf/Stand',
                'code' => 'e495',
            ][$id],
            self::PROPERTY_FACILITY => [
                'id' => 'school',
                'name' => 'Property - Facility',
                'code' => 'f549',
            ][$id],
            self::PROPERTY_NEIGHBORHOOD_WATCH => [
                'id' => 'people-roof',
                'name' => 'Property - Neighborhood Watch',
                'code' => 'e537',
            ][$id],
            self::PROPERTY_RESIDENTIAL_ESTATE => [
                'id' => 'house-building',
                'name' => 'Property - Residential Estate',
                'code' => 'e1b1',
            ][$id],
            self::PROPERTY_STREET => [
                'id' => 'road',
                'name' => 'Property - Street',
                'code' => 'f018',
            ][$id],
            self::PROPERTY_UNIT => [
                'id' => 'door-closed',
                'name' => 'Property - Unit',
                'code' => 'f52a',
            ][$id],
            self::PROPERTY_ZONE => [
                'id' => 'object-group',
                'name' => 'Property - Zone',
                'code' => 'f247',
            ][$id],
            self::PROPERTY => [
                'id' => 'house',
                'name' => 'Property',
                'code' => 'f015',
            ][$id],
            self::PROPERTIES => [
                'id' => 'building-user',
                'name' => 'Property',
                'code' => 'e4da',
            ],
            self::RECENT_ACTIVITY => [
                'id' => 'clock-rotate-left',
                'name' => 'Recent Activity',
                'code' => 'f1da',
            ][$id],
            self::REGISTER => [
                'id' => 'money-check-pen',
                'name' => 'Register',
                'code' => 'f872',
            ][$id],
            self::RELATIONSHIP => [
                'id' => 'people-arrows',
                'name' => 'Relationship',
                'code' => 'e068',
            ][$id],
            self::RELATIONSHIP_DEPENDANT => [
                'id' => 'hands-holding-child',
                'name' => 'Relationship - Dependant',
                'code' => 'e4fa',
            ][$id],
            self::RESIDENT_PORTAL => [
                'id' => 'house-chimney',
                'name' => 'Resident Portal',
                'code' => 'e3af',
            ][$id],
            self::SAVE_APPROVE => [
                'id' => 'cloud-check',
                'name' => 'Save/Approve',
                'code' => 'e35c',
            ][$id],
            self::SELECT_ALL => [
                'id' => 'square-check',
                'name' => 'Select - All',
                'code' => 'f14a',
            ][$id],
            self::SELECT_DATE_SINGLE => [
                'id' => 'calendar-days',
                'name' => 'Select - Date (single)',
                'code' => 'f073',
            ][$id],
            self::SELECT_DATES_DURATION => [
                'id' => 'calendar-range',
                'name' => 'Select - Dates (Duration)',
                'code' => 'e0d6',
            ][$id],
            self::SELECT_INVERT_SELECTION => [
                'id' => 'square-sliders',
                'name' => 'Select - Invert Selection',
                'code' => 'f3f0',
            ][$id],
            self::SELECT_UNSELECT_ALL => [
                'id' => 'square-xmark',
                'name' => 'Select - Unselect All',
                'code' => 'f2d3',
            ][$id],
            self::SETTINGS => [
                'id' => 'gear',
                'name' => 'Settings',
                'code' => 'f013',
            ][$id],
            self::SIGN_IN => [
                'id' => 'arrow-right-to-bracket',
                'name' => 'Sign In',
                'code' => 'f090',
            ][$id],
            self::SIGN_OUT => [
                'id' => 'arrow-right-from-bracket',
                'name' => 'Sign Out',
                'code' => 'f08b',
            ][$id],
            self::SITE_CONTACTS => [
                'id' => 'address-card',
                'name' => 'Site Contacts',
                'code' => 'f2bb',
            ][$id],
            self::SITES => [
                'id' => 'location-dot',
                'name' => 'Sites',
                'code' => 'f3c5',
            ][$id],
            self::SMS_CREDITS => [
                'id' => 'comment-sms',
                'name' => 'SMS Credits',
                'code' => 'f7cd',
            ][$id],
            self::SMSS_FAILED => [
                'id' => 'comment-xmark',
                'name' => 'SMSs Failed',
                'code' => 'f4b5',
            ][$id],
            self::SMSS_SENT => [
                'id' => 'comment-check',
                'name' => 'SMSs Sent',
                'code' => 'f4ac',
            ][$id],
            self::SNIPR_ALERT_DETAILS => [
                'id' => 'memo-circle-info',
                'name' => 'SNIPR - Alert Details',
                'code' => 'e49a',
            ][$id],
            self::SNIPR_ALERTS => [
                'id' => 'siren-on',
                'name' => 'SNIPR - Alerts',
                'code' => 'e02e',
            ][$id],
            self::SNIPR_CAMERAS => [
                'id' => 'camera-cctv',
                'name' => 'SNIPR - Cameras',
                'code' => 'f8ac',
            ][$id],
            self::SNIPR_COMPANY => [
                'id' => 'building-flag',
                'name' => 'SNIPR - Company',
                'code' => 'e4d5',
            ][$id],
            self::SNIPR_DASHBOARD => [
                'id' => 'film',
                'name' => 'SNIPR - Dashboard',
                'code' => 'f008',
            ][$id],
            self::SNIPR_HOTLIST => [
                'id' => 'list-radio',
                'name' => 'SNIPR - Hotlist',
                'code' => 'e1d0',
            ][$id],
            self::SNIPR_INCDENT_DETAILS => [
                'id' => 'siren',
                'name' => 'SNIPR - Incident Details',
                'code' => 'e02d',
            ][$id],
            self::SNIPR_LOOKUP_SEARCH => [
                'id' => 'magnifying-glass',
                'name' => 'SNIPR - Lookup/Search',
                'code' => 'f002',
            ][$id],
            self::SNIPR_MAP => [
                'id' => 'earth-africa',
                'name' => 'SNIPR - Map',
                'code' => 'f57c',
            ][$id],
            self::SNIPR_NOTIFICATIONS => [
                'id' => 'bell',
                'name' => 'SNIPR - Notifications',
                'code' => 'f0f3',
            ][$id],
            self::SNIPR_AREA => [
                'id' => 'map-location-dot',
                'name' => 'SNIPR Area',
                'code' => 'f5a0',
            ][$id],
            self::SNIPR_AREAS => [
                'id' => 'map',
                'name' => 'SNIPR Areas',
                'code' => 'f279',
            ][$id],
            self::SNIPR_PATROL_USERS => [
                'id' => 'users-viewfinder',
                'name' => 'SNIPR Patrol Users',
                'code' => 'e595',
            ][$id],
            self::SNIPR_CEHICLE_DETAILS => [
                'id' => 'car',
                'name' => 'SNIPR Vehicle Details',
                'code' => 'f1b9',
            ][$id],
            self::STAFF => [
                'id' => 'clipboard-user',
                'name' => 'Staff',
                'code' => 'f7f3',
            ][$id],
            self::STAT_DECREASE => [
                'id' => 'chart-line-down',
                'name' => 'Stat decrease',
                'code' => 'f64d',
            ][$id],
            self::STAT_GRAPH => [
                'id' => 'chart-line-up-down',
                'name' => 'Stat Graph',
                'code' => 'e5d7',
            ][$id],
            self::STAT_INCREASE => [
                'id' => 'chart-line-up',
                'name' => 'Stat increase',
                'code' => 'e0e5',
            ][$id],
            self::SYSTEM_COMMAND => [
                'id' => 'message-code',
                'name' => 'System Command',
                'code' => 'e1df',
            ][$id],
            self::TERMS_CONDITIONS => [
                'id' => 'memo-circle-check',
                'name' => 'Terms & Conditions',
                'code' => 'e1d9',
            ][$id],
            self::UNDO => [
                'id' => 'arrow-rotate-left',
                'name' => 'Undo',
                'code' => 'f0e2',
            ][$id],
            self::UNIT => [
                'id' => 'house-building',
                'name' => 'Unit',
                'code' => 'e1b1',
            ][$id],
            self::USER_ADD => [
                'id' => 'user-plus',
                'name' => 'User Add',
                'code' => 'f234',
            ][$id],
            self::USER_APPROVE => [
                'id' => 'user-check',
                'name' => 'User Approve',
                'code' => 'f4fc',
            ][$id],
            self::USER_DENY => [
                'id' => 'user-xmark',
                'name' => 'User Deny',
                'code' => 'f235',
            ][$id],
            self::USER_REMOVE => [
                'id' => 'user-minus',
                'name' => 'User Remove',
                'code' => 'f503',
            ][$id],
            self::USER_SUSPEND => [
                'id' => 'user-clock',
                'name' => 'User Suspend',
                'code' => 'f4fd',
            ][$id],
            self::VEHICLE => [
                'id' => 'car-garage',
                'name' => 'Vehicle',
                'code' => 'f5e2',
            ][$id],
            self::VEHICLES => [
                'id' => 'cars',
                'name' => 'Vehicles',
                'code' => 'f85b',
            ][$id],
            self::VERIFIED => [
                'id' => 'circle-check',
                'name' => 'Verified',
                'code' => 'f058',
            ][$id],
            self::VIEW => [
                'id' => 'eye',
                'name' => 'View',
                'code' => 'f06e',
            ][$id],
            self::VISITED_PROPERTY => [
                'id' => 'house-person-return',
                'name' => 'Visited Property',
                'code' => 'e011',
            ][$id],
            self::VISITORS => [
                'id' => 'users',
                'name' => 'Visitors',
                'code' => 'f0c0',
            ][$id],
            self::BESECURE_STATUS_NORMAL => [
                'id' => 'square-check',
                'name' => 'BeSecure - Status - Normal',
                'code' => 'f14a',
            ][$id],
            self::BESECURE_STATUS_AWAITING_MANUAL_TEST => [
                'id' => 'square-bolt',
                'name' => 'BeSecure - Status - Awaiting Manual Test',
                'code' => 'e265',
            ][$id],
            self::BESECURE_STATUS_SNOOZED => [
                'id' => 'square-z',
                'name' => 'BeSecure - Status - Snoozed',
                'code' => 'e288',
            ][$id],
            self::BESECURE_STATUS_PARKED => [
                'id' => 'square-parking',
                'name' => 'BeSecure - Status - Parked',
                'code' => 'f540',
            ][$id],
            self::BESECURE_STATUS_OFFLINE => [
                'id' => 'square-dashed',
                'name' => 'BeSecure - Status - Offline',
                'code' => 'e269',
            ][$id],
            self::REPORTS => [
                'id' => 'file-invoice',
                'name' => 'Reports',
                'code' => 'f570',
            ],
            self::SURVEYS_POLLS => [
                'id' => 'square-poll-vertical',
                'name' => 'Surveys & Polls',
                'code' => 'f681',
            ],
            self::OS_TECH_TIP => [
                'id' => 'lightbulb-gear',
                'name' => '1s Tech Tip',
                'code' => 'e5fd',
            ][$id],
        };
    }
}
