<?php

namespace onespace\tools\assets;

use yii\web\AssetBundle;
use yii\web\View;

/**
 * Asset bundle for tracking code
 * 
 * In order to enable Clarity tracking, the CLARITY_TRACKING_PROJECT environment variable should be set to the Clarity project ID
 */
class TrackingAsset extends AssetBundle {
    public $sourcePath = __DIR__;
    // public $basePath = '@webroot';
    // public $baseUrl = '@web';
    public $css = [];
    public $js = [
        [
            'js/clarity.js',
            'position' => View::POS_HEAD,
        ]
    ];
    public $depends = [];


    /**
     * Registers the CSS and JS files with the given view.
     * @param \yii\web\View $view the view that the asset files are to be registered with.
     */
    public function registerAssetFiles($view)
    {
        if (getenv("CLARITY_TRACKING_PROJECT")) {
            $view->registerJsVar("clarity_tracking_project", getenv("CLARITY_TRACKING_PROJECT"), View::POS_HEAD);
            $view->registerJs('
            if (typeof(clarity_tracking_project) !== "undefined") {
                loadClarity(window, document, "clarity", "script", clarity_tracking_project);
                window.clarity("consent");
            }', View::POS_HEAD);
        }

        return parent::registerAssetFiles($view);
    }
}
