# OneSpace Widgets Docs

## Assets

- ApexChartsAsset
- ChartJSAsset
- FontAwsome5Asset
- FontAwsome6Asset
- MapAsset
- OSWidgetsAsset
- TinyMCEAsset

---

## Components

### AzureDB

Tools for connecting to the Azure Besecure DB.

| Key | Value |
| --- | ----- |
| Namespace | `onespace\tools\components\azuredb` |
| Files | `validators\AzureExistValidator.php` |
| | `validators\AzureUniqueValidator.php` |
| | `ActiveQuery.php` |
| | `AzureActiveRecord.php` |
| | `Command.php` |
| | `Connection.php` |
| | `DataReader.php` |
| | `Query.php` |
| | `QueryBuilder.php` |
| Status | Functional |

### TDEngine

Tools for connecting to the TD Engine timeseries DB.

| Key | Value |
| --- | ----- |
| Namespace | `onespace\tools\components\tdengine` |
| Files | `ActiveQuery.php` |
| | `ActiveQuery.php` |
| | `Command.php` |
| | `Connection.php` |
| | `Query.php` |
| | `QueryBuilder.php` |
| | `Schema.php` |
| | `TDEngineActiveRecord.php` |
| Status | Mostly Functional |

### Rabbit

Helping tools for working with and for RabbitMQ.

| Key | Value |
| --- | ----- |
| Namespace | `onespace\tools\components` |
| Files | `Rabbit.php` |
| Status | Needs testing |

---

## Helpers

### Enum Helpers

#### UnbackedHelper

Trait for providing tools to unbacked ENUMS.

`use \onespace\tools\helpers\enum\UnbackedHelper;`

### Spreadsheet Helpers

Traits for assisting with helping working with spreadsheets.

- CSVLoader
- ExcelLoader

#### CSVLoader

Trait for assisting with CSV files.

`use \onespace\tools\helpers\traits\CSVLoader;`

#### ExcelLoader

Trait for assisting with Excel (.xlsx) files.

`use \onespace\tools\helpers\traits\ExcelLoader;`

### Terminal Helpers

- TerminalFeedback

#### TerminalFeedback

Tool for assist with various Terminal tasks. Specifically for showing progress as a large number of records are being processed.

`use \onespace\tools\helpers\traits\TerminalFeedback;`

### General Helpers

- GetView
- Position
- Minifier

#### GetView

Trait for assisting with getting the `View`, mainly within the context of a static method.

`use \onespace\tools\helpers\traits\GetView;`

#### Position

Future ENUM (currently a standard class) for indicating the position of various items on the screen.

`use \onespace\tools\helpers\Position;`

#### Minifier

Methods for minifing JS and CSS when loading inline.

`use \onespace\tools\helpers\Minifier;`

---

## Widgets

### Charts

- ApexCharts
- ChartJS

#### ApexCharts

Widget for drawing charts using [APEX CHARTS](https://apexcharts.com).

__Docs:__ [https://apexcharts.com/docs/](https://apexcharts.com/docs/)

`use \onespace\tools\widgets\ApexCharts\ApexCharts;`

| Key | Type | Default |
| --- | ---- | ------- |
| `options` | array | |
| `deferLoading` | bool | false |
| `id` | string | |

#### ChartJS

Widget for drawing charts using [ChartJS](https://www.chartjs.org).

__Docs:__ [https://www.chartjs.org](https://www.chartjs.org)

`use \onespace\tools\widgets\chartjs\ChartJs;`

| Key | Type | Default |
| --- | ---- | ------- |
| id | string | |
| jsLoad | int | \yii\web\View::POS_READY |
| data | array\|string | `[]` |

---

### Calendars

- FullCalendar

#### FullCalendar

Widget for drawing calendar using the tool [FullCalendar](https://fullcalendar.io)

__Docs:__ [https://fullcalendar.io/docs](https://fullcalendar.io/docs)

`use \onespace\tools\widgets\calendar\FullCalendar;`

| Key | Type | Default |
| --- | ---- | ------- |
| options | array | |
| events | array | `[]` |
| eventSources | array | `[]` |
| initialView | string | `dayGridMonth` |
| navLinks | bool | true |
| header_layout | array | `['start' => 'prev,next today', 'center' => 'title', 'end' => 'dayGridMonth timeGridWeek timeGridOneDay listWeek' ]` |
| params_overwrite | string\|array | |
| modal | string | |
| custom_click_event | string | |
| eventName | string | `event` |

---

### File Uploading

- Dropzone
- ImageConverterFileInput

#### Dropzone

Widget for creating [Dropzone](https://www.dropzone.dev) file uploader.

__Docs:__ [https://docs.dropzone.dev](https://docs.dropzone.dev)

| Key | Type | Default |
| --- | ---- | ------- |
| id | string | |
| action | string | |
| chunking | bool | true |
| chunkSize | int | 2000000 |
| forceChunking | bool | false |
| retryChunks | bool | false |
| retryChunksLimit | int | 3 |
| parallelUploads | int | 3 |
| parallelChunkUploads | bool | false |
| timeout | int | 120000 |
| maxFilesize | int | 5000000000 |
| maxFiles | int\|null | null |
| acceptedFiles | string\|null | null |
| options | array | `[]` |
| hiddenInputs | array | `[]` |
| useForm | bool | true |
| hook | string | |
| debug | bool | |
| csrf | string | '_csrf' |

#### ImageConverterFileInput

Self build widget for handling drag and drop, as well as file type conversion for image uploading. Can convert an image from .jpg or .png to .webp, all on the browser.

| Key | Type | Default |
| --- | ---- | ------- |
| maxWidth | int\|null | null |
| maxHeight | int\|null | null |
| showPreview | bool | true |
| includeFormControl | bool | false |
| accept | string | 'image/*' |
| imgId | string | |
| form | \yii\bootstrap\ActiveForm | |
| layout | int | 0 |

---

### WYSIWYG

- GrapeJS
- TinyMCE

#### GrapeJS

Widget for using the WYSIWYG fancy editor [GrapeJS](https://grapesjs.com)

__Docs:__ [https://grapesjs.com/docs/](https://grapesjs.com/docs/)

| Key | Type | Default |
| --- | ---- | ------- |
| isNewsletter | bool | false |
| height | string | |
| width | string | |
| content | string | `''` |
| jsonContent | string\|array\|false | false |
| fromElement | bool | true |
| customLoadScript | string | |
| extraScripts | string | |
| customStyles | string | |
| storageType | int | |
| storageKey | string | |
| options | array | `[]` |
| id | string | |
| debug | bool | false |

#### TinyMCE

Widget for using the WYSIWYG fancy editor [TinyMCE](https://www.tiny.cloud/tinymce/)

__Docs:__ [https://www.tiny.cloud/docs/tinymce/latest/](https://www.tiny.cloud/docs/tinymce/latest/)

| Key | Type | Default |
| --- | ---- | ------- |
| menubar | string | 'file edit view insert format table' |
| toolbar | string | 'undo redo \| blocks \| bold italic underline strikethrough \| alignleft aligncenter alignright alignjustify \| fontfamily \| bullist numlist outdent indent \| link unlink image \| wordcount charmap emoticons removeformat hr' |
| plugins | string | 'advlist autolink lists link image charmap preview anchor pagebreak table media wordcount charmap emoticons' |
| fonts | array | `[...Too long for this table...]` |
| fontCss | string\|null | null |
| uploadImages | bool | true |

---

### Icons

- FontAwesomeIcon
- FontAwesomeIcon6
- Glyphicons

#### FontAwesomeIcon

Tool for generating FontAwesome 5 icons.

___DEPRECATED___ - do not use, use FontAwesomeIcon6 (see below)

#### FontAwesomeIcon6

Widget for using [FontAwesome Icons](https://fontawesome.com) (version 6)

__Search:__ [https://fontawesome.com/search](https://fontawesome.com/search)
__Docs:__ [https://docs.fontawesome.com](https://docs.fontawesome.com)

| Key | Type | Default |
| --- | ---- | ------- |
| colour | string\|null | null |
| identifier | string\|null | null |
| content | string | `&nbsp;` |
| icon | `\onespace\tools\widgets\icons\OSIcon` | |

| Style Type | FA Icon Type |
| ---------- | ------------ |
| solid | fa-solid |
| regular | fa-regular |
| light | fa-light |
| duotone | fa-duotone |
| thin | fa-thin |
| brand | fa-brands |

| Valid Colours |
| ------------- |
| light-blue |
| aqua |
| green |
| yellow |
| red |
| gray |
| navy |
| teal |
| purple |
| orange |
| maroon |
| black |

#### Glyphicons

Widget for using Bootstrap 3 Glyphicons

__Docs:__ [https://getbootstrap.com/docs/3.3/components/#glyphicons](https://getbootstrap.com/docs/3.3/components/#glyphicons)

| Key | Type | Default |
| --- | ---- | ------- |
| colour | string\|null | null |
| identifier | string\|null | null |
| content | string | `&nbsp;` |

| Valid Colours |
| ------------- |
| light-blue |
| aqua |
| green |
| yellow |
| red |
| gray |
| navy |
| teal |
| purple |
| orange |
| maroon |
| black |

---

### HTML Input

- DateSelector
- DuelDateSelector
- DuelListBox
- Switcher

#### DateSelector

Widget for generating a `<input type="date">` with all of the normal properties available.

| Key | Type | Default |
| --- | ---- | ------- |
| min | string | |
| max | string | |

#### DuelDateSelector

Widget for drawing a duel date selector. The idea is that you can select both start and end date.

| Key | Type | Default |
| --- | ---- | ------- |
| leftAttribute | string | |
| rightAttribute | string | |
| leftName | string | |
| rightName | string | |
| leftOptions | array | `[]` |
| rightOptions | array | `[]` |
| leftValue | string | |
| rightValue | string | |

#### DuelListBox

Widget for generating a left and right selection box, with buttons to move data between the two.

| Key | Type | Default |
| --- | ---- | ------- |
| leftColumn | array | `[]` |
| rightColumn | array | `[]` |
| leftHeading | string | `'&nbsp;'` |
| rightHeading | string | `'&nbsp;'` |
| filter | bool | false |

#### Switcher

Widget for drawing a toggle button based on a checkbox.

| Key | Type | Default |
| --- | ---- | ------- |
| leftLabel | string | |
| rightLabel | string | |
| checked | bool | |

---

### Loaders

- DotLoader
- LineSpinLoader
- SpinnerLoader
- TextLoader
- BounceLoader

#### DotLoader

Widget for drawing a dot loader. Uses the FA6 icon `spinner`

| Key | Type | Default |
| --- | ---- | ------- |
| size | string | small |
| colour | string | |

| Size Const | Size ID |
| ---------- | ------- |
| `SIZE_SMALL` | small |
| `SIZE_MEDIUM` | medium |
| `SIZE_LARGE` | large |

#### LineSpinLoader

Widget for drawing a line spinning loader. Uses the FA6 icon `spinner-third`

| Key | Type | Default |
| --- | ---- | ------- |
| size | string | small |
| colour | string | |
| drawPath | bool | false |

| Size Const | Size ID |
| ---------- | ------- |
| `SIZE_SMALL` | small |
| `SIZE_MEDIUM` | medium |
| `SIZE_LARGE` | large |

#### SpinnerLoader

Widget for drawing a dots spinner loader. Uses the FA6 icon `loader`

| Key | Type | Default |
| --- | ---- | ------- |
| size | string | small |
| colour | string | |

| Size Const | Size ID |
| ---------- | ------- |
| `SIZE_SMALL` | small |
| `SIZE_MEDIUM` | medium |
| `SIZE_LARGE` | large |

#### TextLoader

Widget for drawing a basic text loader.

| Key | Type | Default |
| --- | ---- | ------- |
| text | string | `Loading...` |
| spinner | string\|null | null |
| animate | bool | false |
| tag | string | `p` |

#### BounceLoader

Widget for drawing the bouncing logo loader.

| Key | Type | Default |
| --- | ---- | ------- |
| id | string | |

---

### File Browsing

- TinyFileBrowser

#### TinyFileBrowser

Widget for drawing file browsing web interface. Adapted from [Tiny File Manager](https://tinyfilemanager.github.io)

__Docs:__ [https://github.com/prasathmani/tinyfilemanager/wiki](https://github.com/prasathmani/tinyfilemanager/wiki)

| Key | Type | Default |
| --- | ---- | ------- |
| file_path | string | |
| ftp_filesystem | \League\Flysystem\Filesystem | |
| ftp_path | string | `/` |
| ftp_url | string | `''` |
| is_readonly | bool | false |
| selected_estate | int | |
| edit_files | bool | false |
| hide_columns | bool | true |
| csrfToken | string | `_csrf` |
| default_timezone | string | `Africa/Johannesburg` |
| datetime_format | string | `d/m/Y g:i A` |

---

### Maps

- GoogleMaps

#### GoogleMaps

Widget for drawing a colour overlayed Google Map.

| Key | Type | Default |
| --- | ---- | ------- |
| customControls | array | `[]` |
| clientOptions | array | `[]` |
| styleJson | string | `''` |
| markers | array\|null | `[]` |
| markerEvents | array | `[]` |
| heatmap | array\|null | `[]` |

| Positions |
| --------- |
| `CONTROL_POSITION_BOTTOM` |
| `CONTROL_POSITION_BOTTOM_CENTER` |
| `CONTROL_POSITION_BOTTOM_LEFT` |
| `CONTROL_POSITION_BOTTOM_RIGHT` |
| `CONTROL_POSITION_CENTER` |
| `CONTROL_POSITION_LEFT` |
| `CONTROL_POSITION_LEFT_BOTTOM` |
| `CONTROL_POSITION_LEFT_CENTER` |
| `CONTROL_POSITION_LEFT_TOP` |
| `CONTROL_POSITION_RIGHT` |
| `CONTROL_POSITION_RIGHT_BOTTOM` |
| `CONTROL_POSITION_RIGHT_CENTER` |
| `CONTROL_POSITION_RIGHT_TOP` |
| `CONTROL_POSITION_TOP` |
| `CONTROL_POSITION_TOP_CENTER` |
| `CONTROL_POSITION_TOP_LEFT` |
| `CONTROL_POSITION_TOP_RIGHT` |

| Marker Colour ID | Marker Text |
| ---------------- | ----------- |
| `MS_MARKER_COLOUR_YELLOW` | yellow |
| `MS_MARKER_COLOUR_BLUE` | blue |
| `MS_MARKER_COLOUR_GREEN` | green |
| `MS_MARKER_COLOUR_LIGHTBLUE` | lightblue |
| `MS_MARKER_COLOUR_ORANGE` | orange |
| `MS_MARKER_COLOUR_PINK` | pink |
| `MS_MARKER_COLOUR_PURPLE` | purple |
| `MS_MARKER_COLOUR_RED` | red |
| `MS_MARKER_DOT` | -dot |
| `MS_MARKER_NO_DOT` | `''` |

---

### Misc

- Luminance

#### Luminance

Widget for determining the luminance of a colour and the appropriate background colour.

##### Properties

| Key | Type | Default | Details |
| --- | ---- | ------- | ------- |
| hex | string | | REQUIRED. The RGB Hex colour value. Can be parsed with or without a leading #. |
| lightColour | string | '#fff' | OPTIONAL. The light text colour. Default is WHITE. |
| darkColour | string | '#000' | OPTIONAL. The dark text colour. Default is BLACK. |

##### Methods

| Method Name | Returns | Details |
| ----------- | ------- | ------- |
| isLight() | bool | Whether the luminance of the parsed hex is light. |
| isDark() | bool | Whether the luminance of the parsed hex is dark. |
| textColour() | string | Added method for returning the appropriate text colour based on the luminance of the parsed RGB hex. |

---

### UI

- EstateLogo
- ItemHeader
- Modal
- OneSpaceGridview
- Page
- PortalButton
- ProfilePic
- BannerEstatesAdmin
- BannerEstatesErf
- BannerEstatesBoth
- BannerGeneralHeader
- BannerNarrowUserInfo
- BannerWideUserInfo
- DuelPanel
- MainPanel
- CalendarView
- DataCard
- DataCardsView
- ExpandedDetails

#### EstateLogo

Widget to draw an estate logo.

| Key | Type | Default | Details |
| --- | ---- | ------- | ------- |
| options | array | `[]` | Any `<img>` element properties to add to the `<img>` tag. |
| loading | string | `'lazy'` | Explicitly state the loading method for the `<img>`. |
| link | array | | If you wish to wrap the image in a link, pass the desired parameters for the `<a>` tag here. If empty, a link will not be created. |
| fallback | string | `'question'` | The Font Awesome Icons v5 identifier as a fallback image. |
| drawover | string | | A drawover text to be placed if no image is drawn by default. |
| id | string | | REQUIRED. The id of the estate, who's logo you want. |

#### ItemHeader

Widget to draw out the standard `User Portal` OneSpaceGridview header

| Key | Type | Default | Details |
| --- | ---- | ------- | ------- |
| title | string | | If desired, the title to be placed into the header. This is just a plain text / html header. |
| title_position | `\onespace\tools\widgets\ui\base\Align` | `Align::LEFT` | The desired alignment of the title on the header. |
| button | array\|null | | If desired, the button to be placed into the header. This value is specifically the text of the button. |
| button_position | `\onespace\tools\widgets\ui\base\Align` | `Align::CENTER` | The desired alignment of the button on the header. |
| filter | string | | If desired, the filter to be placed into the header. This value is specifically the id of the filter row, which should be hidden / unhidden. |
| filter_position | `\onespace\tools\widgets\ui\base\Align` | `Align::RIGHT` | The desired alignment of the filter on the header. |
| grid_template_columns | string | | If the alignment does not sufficently lay out the elements as desired, you can parse desired CSS here. Specifically the value to be placed as a `grid-template-columns` property. |
| hr | bool | false | Added param for drawing a `<hr>` on the bottom of the filter. |

#### Modal

Widget to draw bootstrap 3 custom layout modal boxes.

| Key | Type | Default | Details |
| --- | ---- | ------- | ------- |
| content | string | | OPTIONAL. If static content of the modal box is desired, This property should contain this content. If both `$this->content` and `$this->link` is set, only `$this->content` will get loaded. |
| link | string | | OPTIONAL. If dynamic content should be rendered as a `partialRender()`, this should contain the link to that page. If both `$this->content` and `$this->link` is set, only `$this->content` will get loaded. |
| button | string | | REQUIRED. The button or buttons (or whatever element), which, when clicked will invoke the modal. |
| title | string | | OPTIONAL. The title to put at the top of the modal box. |
| id | string | | The overall id of the modal. Set dynamically so that more than one modal may exist on a page. |
| options | array | `[]` | Any html options to attach to the modal element. |
| overwrite_js | bool | false | Whether or not to overwrite the JS. |
| large_modal | bool | false | Draw a larger size modal box. |

#### OneSpaceGridview

Widget to draw Onespace `User Portal` styled GridViews.

| Key | Type | Default | Details |
| --- | ---- | ------- | ------- |
| header_area | string | | he contents of the header area as desired. Can be any ordinary string, or parsed using a widget, ideally the `ItemHeader` widget. |
| footer_area | string\|Closure | | The contents of the header area as desired. Can be any ordinary string, or parsed using widget. |
| filter_id | string | | The id of the filter row. If this is set, the filter row is hidden by default, and the id should be passed to the filter button to show / hide the filter. |
| row_outline | string\|Closure | | The CSS Class for setting the row outline. This can be either an string (See constants below) specifying the common outline for all body rows, or an anonymous function that returns the specified outline based on your own parameters. The anonymous function will be called once for every data model returned by [[dataProvider]]. It should have the following signature: `function ($model, $key, $index, $grid)` |
| pjax_id | string | | The id of the PJAX element if you need to specify one. Otherwise it'll randomly generate. |
| use_pjax | bool | true | Whether or not to use PJAX automatically. Set to false to set your own PJAX options. |
| title | string | | If desired, the title to be placed into the header. This is just a plain text / html header. |
| title_position | `\onespace\tools\widgets\ui\base\Align` | `Align::LEFT` | The desired alignment of the title on the header. |
| button | array | | If desired, the button to be placed into the header. This value is specifically the text of the button. |
| button_position | `\onespace\tools\widgets\ui\base\Align` | `Align::CENTER` | The desired alignment of the button on the header. |
| filter | string | | If desired, the filter to be placed into the header. This value is specifically the id of the filter row, which should be hidden / unhidden. |
| filter_position | `\onespace\tools\widgets\ui\base\Align` | `Align::RIGHT` | The desired alignment of the filter on the header. |
| grid_template_columns | string | | If the alignment does not sufficently lay out the elements as desired, you can parse desired CSS here. Specifically the value to be placed as a `grid-template-columns` property. |

| Row Outline Key | Outline CSS |
| --------------- | ----------- |
| ROW_OUTLINE_WHITESPACE | `ui-outline-whitespace` |
| ROW_OUTLINE_MAIN | `ui-outline-main` |
| ROW_OUTLINE_ACCENT | `ui-outline-accent` |
| ROW_OUTLINE_SMOKEYGREY | `ui-outline-smokeygrey` |
| ROW_OUTLINE_COOLGREY | `ui-outline-coolgrey` |
| ROW_OUTLINE_SNIPR | `ui-outline-snipr` |

#### Page

Widget to draw the general page outline, used mostly in the context of `User Portal`.

| Key | Type | Default | Details |
| --- | ---- | ------- | ------- |
| options | array | `[]` | Any html properties to add to the main container div. `class`, `style`, `id` etc. |
| jsFile | string | | Parse the path of a JS file to register as part of the widget. This is for any custom JS you may need on the page. |
| cssFile | string | | Parse the path of a CSS file to register as part of the widget. This is for any custom CSS you may need on the page. |
| elements | array | | The elements to put onto the page. Parse html, widgets, $this->render or even just a plain string. |
| rp | bool | true | If the page is a user portal formatted page. |
| banner | string | | The banner to put on the top of the page in the `content-header`. |
| bannerPadding | string | '0' | The padding underneath the the top banner. |

#### PortalButton

Widget to draw a standard User Portal button.

| Key | Type | Default | Details |
| --- | ---- | ------- | ------- |
| icon | string\|`\onespace\tools\widgets\icons\OSIcon` | 'cat' | The icon to place onto the screen. |
| text | string | 'Placeholder Cat' | The default text to place under the icon. |
| colour | string | '#254C5A' | The colour of the icon and text, default is #254C5A - Corporate Blue (official Onespace branding colour) |
| style | string | 'light' | The styling of the icon, options are: `solid`, `regular`, `light`, `duotone`, `thin`, `brand`. |
| href | string | 'javascript:void(0)' | The default link of the icon. |
| title | string | | The html title to show to the user on hover. |
| border_top | bool | false | Whether or not to place a border on top of the icon. |
| border_bottom | bool | false | Whether or not to place a border on the bottom of the icon. |
| border_left | bool | false | Whether or not to place a border on the left of the icon. |
| border_right | bool | false | Whether or not to place a border on the right of the icon. |
| disabled | bool | false | Whether or not the icon should be disabled, but still visable to the user. |
| hidden | bool | false | Whether or not the icon should be completely hidden. |
| options | array | `[]` | Any options to add onto the button. |

#### ProfilePic

Widget to draw the logged in user's profile picture, as a link if desired.

| Key | Type | Default | Details |
| --- | ---- | ------- | ------- |
| options | array | `[]` | Any `<img>` element properties to add to the `<img>` tag. |
| loading | string | `'lazy'` | Explicitly state the loading method for the `<img>`. |
| link | array | | If you wish to wrap the image in a link, pass the desired parameters for the `<a>` tag here. If empty, a link will not be created. |
| fallback | string | `'question'` | The Font Awesome Icons v5 identifier as a fallback image. |
| drawover | string | | A drawover text to be placed if no image is drawn by default. |
| userClass | string | | The full namespace and class name of the user model class. Options are `app\models\User` or `common\models\User`. |

#### BannerEstatesAdmin

Widget to draw a banner with the listed estate management user's estates.

| Key | Type | Default | Details |
| --- | ---- | ------- | ------- |
| pjax_id | string | | The id of the PJAX element if you need to specify one. Otherwise it'll randomly generate. |
| namespace | string | TopBanner::NAMESPACE_APP | REQUIRED. The variable part of the namespace between the "split" and "non-split" versions of Central. Set `app` by default. Set to `common` if working in a split context. |
| header_text | string | | OPTIONAL. The header text to place onto the banner. |
| container_class | string | | OPTIONAL. The container class or classes to apply to the banner. May also be applied to another non banner div on the page. |

| Namespaces |
| ---------- |
| NAMESPACE_APP |
| NAMESPACE_COMMON |

#### BannerEstatesErf

Widget to draw banner with the listed erf owner user's estates.

| Key | Type | Default | Details |
| --- | ---- | ------- | ------- |
| pjax_id | string | | The id of the PJAX element if you need to specify one. Otherwise it'll randomly generate. |
| namespace | string | TopBanner::NAMESPACE_APP | REQUIRED. The variable part of the namespace between the "split" and "non-split" versions of Central. Set `app` by default. Set to `common` if working in a split context. |
| header_text | string | | OPTIONAL. The header text to place onto the banner. |
| container_class | string | | OPTIONAL. The container class or classes to apply to the banner. May also be applied to another non banner div on the page. |

| Namespaces |
| ---------- |
| NAMESPACE_APP |
| NAMESPACE_COMMON |

#### BannerEstatesBoth

Widget to draw the estate banner with the user's estates, in the context of a user being both an estate manager and a erf owner, which may be on a seperate estate.

| Key | Type | Default | Details |
| --- | ---- | ------- | ------- |
| pjax_id | string | | The id of the PJAX element if you need to specify one. Otherwise it'll randomly generate. |
| namespace | string | TopBanner::NAMESPACE_APP | REQUIRED. The variable part of the namespace between the "split" and "non-split" versions of Central. Set `app` by default. Set to `common` if working in a split context. |
| header_text | string | | OPTIONAL. The header text to place onto the banner. |
| container_class | string | | OPTIONAL. The container class or classes to apply to the banner. May also be applied to another non banner div on the page. |

| Namespaces |
| ---------- |
| NAMESPACE_APP |
| NAMESPACE_COMMON |

#### BannerGeneralHeader

Widget to draw a general coloured without any special features. Has a title and links.

| Key | Type | Default | Details |
| --- | ---- | ------- | ------- |
| title | string | | The text title to place into the header. |
| title_align | `\onespace\tools\widgets\ui\base\Align` | `Align::LEFT` | The alignment of the parsed title. |
| links | array | | Any links to place in a top narrow banner. |
| links_align | `\onespace\tools\widgets\ui\base\Align` | `Align::RIGHT` | The alignment of the parsed links. |
| namespace | string | TopBanner::NAMESPACE_APP | REQUIRED. The variable part of the namespace between the "split" and "non-split" versions of Central. Set `app` by default. Set to `common` if working in a split context. |
| header_text | string | | IGNORED. The header text to place onto the banner. |
| container_class | string | | OPTIONAL. The container class or classes to apply to the banner. May also be applied to another non banner div on the page. |

| Namespaces |
| ---------- |
| NAMESPACE_APP |
| NAMESPACE_COMMON |

#### BannerNarrowUserInfo

Widget to draw the top narrow banner. It contains user's personal information with narrow margins.

| Key | Type | Default | Details |
| --- | ---- | ------- | ------- |
| banner_top | string | '2.7rem' | The gap between the banner and main content. |
| namespace | string | TopBanner::NAMESPACE_APP | REQUIRED. The variable part of the namespace between the "split" and "non-split" versions of Central. Set `app` by default. Set to `common` if working in a split context. |
| header_text | string | | IGNORED. The header text to place onto the banner. |
| container_class | string | | OPTIONAL. The container class or classes to apply to the banner. May also be applied to another non banner div on the page. |

| Namespaces |
| ---------- |
| NAMESPACE_APP |
| NAMESPACE_COMMON |

#### BannerWideUserInfo

Widget to draw the top wide banner. It contains user's personal information with wide margins.

| Key | Type | Default | Details |
| --- | ---- | ------- | ------- |
| banner_top | string | '2.7rem' | The gap between the banner and main content. |
| namespace | string | TopBanner::NAMESPACE_APP | REQUIRED. The variable part of the namespace between the "split" and "non-split" versions of Central. Set `app` by default. Set to `common` if working in a split context. |
| header_text | string | | OPTIONAL. The header text to place onto the banner. |
| container_class | string | | OPTIONAL. The container class or classes to apply to the banner. May also be applied to another non banner div on the page. |

| Namespaces |
| ---------- |
| NAMESPACE_APP |
| NAMESPACE_COMMON |

#### DuelPanel

Widget to draw out the sub page element the "Duel Panel" Which is a double column panel into which the contents of the page should be rendered. Handles the styling etc automatically.

| Key | Type | Default | Details |
| --- | ---- | ------- | ------- |
| options | array | `[]` | Any html properties to add to the main container div. `class`, `style`, `id` etc. |
| jsFile | string | | Parse the path of a JS file to register as part of the widget. This is for any custom JS you may need on the page. |
| cssFile | string | | Parse the path of a CSS file to register as part of the widget. This is for any custom CSS you may need on the page. |
| leftPanel | string\|array | | The contents of the left hand panel. Parse html, widgets, $this->render or even just a plain string. |
| rightPanel | string\|array | | The contents of the right hand panel. Parse html, widgets, `$this->render` or even just a plain string. |
| bannerLeft | string | | If desired place a banner on the top of the left hand panel. Parse html, widgets, $this->render or even just a plain string. Designed to work with the `TopBanner` widget. |
| bannerRight | string | | If desired place a banner on the top of the right hand panel. Parse html, widgets, $this->render or even just a plain string. Designed to work with the `TopBanner` widget. |
| leftPanelClass | string | | Add a custom class to the left panel. |
| rightPanelClass | string | | Add a custom class to the right panel. |
| resizable | bool | false | Whether or not the duel panels are resizable. |
| PanelSizes | `\onespace\tools\widgets\ui\panels\PanelSizes` | | Set a specific size configuration for the panels. |

#### MainPanel

Widget to draw out the sub page element the "Main Panel" Which is a single column panel into which the contents of the page should be rendered. Handles the styling etc automatically.

| Key | Type | Default | Details |
| --- | ---- | ------- | ------- |
| options | array | `[]` | Any html properties to add to the main container div. `class`, `style`, `id` etc. |
| jsFile | string | | Parse the path of a JS file to register as part of the widget. This is for any custom JS you may need on the page. |
| cssFile | string | | Parse the path of a CSS file to register as part of the widget. This is for any custom CSS you may need on the page. |
| content | string\|array | | The contents of the panel to render. Parse html, widgets, `$this->render` or even just a plain string. May be not parsed for an empty panel. |
| topRoundedCorners | bool | false | hether the top corners of the main panel will be rounded. |

#### CalendarView

Widget to draw page view of the Resident Portal calendar type.

| Key | Type | Default | Details |
| --- | ---- | ------- | ------- |
| calendar | string | | Should be parsed as `FullCalendar::widget`. The actual calendar. |
| info_column | string | | Suggested parsed as `OneSpaceGridview::widget`, but anything can be parsed. |

#### DataCard

Widget to draw for drawing an interface card link.

| Key | Type | Default | Details |
| --- | ---- | ------- | ------- |
| link | string | | REQUIRED. The link the card should load. |
| image | string\|null | | OPTIONAL. The image to draw onto the card. |
| heading | string | | OPTIONAL. The heading of the card. |
| details | string | | OPTIONAL. The text details of the card. |
| edit | string\|array\|false | false | OPTIONAL. The `edit` link. Set to false to switch off. |
| delete | string\|false | false | OPTIONAL. The `delete` link. Set to false to switch off. |
| selected | bool | false | Whether the card is in a selected state. |

#### DataCardsView

Widget for laying out the Data Card interface.

| Key | Type | Default | Details |
| --- | ---- | ------- | ------- |
| data | array | | The cards to draw into the view. an array with the following possible keys: `['link' => ..., 'image' => ..., 'heading' => ..., 'details' => ..., 'edit' => ..., * 'delete' => ..., 'selected' => ..., ];` |
| use_pjax | bool | true | Whether or not to use PJAX automatically. Set to false to set your own PJAX options. |

#### ExpandedDetails

Widget for the datacard details interface.

| Key | Type | Default | Details |
| --- | ---- | ------- | ------- |
| image | string\|null | | The image to put on the page. |
| fields | array | | The fields to place into the data columns under the image. Should be formatted as follows: `['Table Key' => 'Table Value', ...];`. Both `Table Key` & `Table Value` will be printed on the page. |
