<?php

namespace onespace\tools\widgets\ui\views\calendar;

use onespace\tools\widgets\ui\base\Tools;
use yii\base\Widget;

/**
 * Page view of the Resident Portal calendar type.
 */
final class CalendarView extends Widget {

    use Tools;

    /**
     * Should be parsed as `FullCalendar::widget`. The actual calendar.
     *
     * @var string  $calendar
     * 
     * @access  public
     */

    public string $calendar;

    /**
     * Suggested parsed as `OneSpaceGridview::widget`, but anything can be parsed.
     *
     * @var string  $info_column
     * 
     * @access  public
     */

    public string $info_column;


    /**
     * {@inheritdoc}
     *
     * @return void
     * 
     * @access  public
     */

    public function init(): void {
        parent::init();
        $this->calendar ??= "&nbsp;";
        $this->info_column ??= "&nbsp;";
        $view = $this->getView();
        $view->registerCss($this->calendar_css());
    }


    /**
     * {@inheritdoc}
     * 
     * @return  string
     * 
     * @access  public
     */

    public function run(): string {
        $view = '';
        $view .= "<div class='calendar-page-container'>";
        $view .= "<div class='calendar-page-calendar'>{$this->calendar}</div>";
        $view .= "<div class='calendar-page-data ui-calendar-details-padding'>{$this->info_column}</div>";
        $view .= "</div>"; // row
        return $view;
    }


    /**
     * {@inheritdoc}
     * 
     * @return string
     * 
     * @access  private
     */

    private function calendar_css(): string {
        return $this->minify_css(file_get_contents(__DIR__ . '/css/calendar.css'));
    }
}
