<?php

namespace onespace\tools\widgets\ui\base;

use onespace\tools\widgets\ui\base\Tools;
use yii\base\Widget;

/**
 * Base class for common tools used by the various panel widgets.
 * 
 * @see src/ui/panels/MainPanel.php
 * @see src/ui/panels/DuelPanel.php
 * 
 * @author  Gareth Palmer <gareth@one-space.co.za>
 */

class PanelBase extends Widget {

    use Tools;


    /**
     * Any html properties to add to the main container div. `class`, `style`, `id` etc.
     * 
     * @var array   $options    Default: []
     * 
     * @access  public
     */

    public array $options = [];

    /**
     * Parse the path of a JS file to register as part of the widget. This is for any custom JS you may need on the page.
     * 
     * @var string  $js_file
     * 
     * @access  public
     */

    public string $js_file;
    /**
     * Parse the path of a CSS file to register as part of the widget. This is for any custom CSS you may need on the page.
     * 
     * @var string  $css_file
     * 
     * @access  public
     */

    public string $css_file;


    /**
     * @inheritdoc
     * 
     * Registers the parsed JS & CSS. Should be called as `$item = parent::run()`.
     * 
     * @return  string
     */

    public function run(): string {
        parent::run();
        $this->register_any_js_css();
        return '';
    }


    /**
     * Handles the loading of JS & CSS into the page, if parsed.
     * 
     * @access  protected
     */

    protected function register_any_js_css(): void {
        $view = $this->getView();
        if (isset($this->js_file)) {
            $view->registerJs(file_get_contents($this->minify_js($this->js_file)));
        }
        if (isset($this->css_file)) {
            $view->registerCss(file_get_contents($this->minify_css($this->css_file)));
        }
    }


    /**
     * Generates the main div wrapper for the page or element being generated.
     * 
     * Automatically parses the `$this->options` onto the div.
     * 
     * @param   string  $id The primary class for the div.
     * 
     * @return  string  Something like: `<div class='myClass' ... >`
     */

    protected function set_main_div(string $id): string {
        $page = "<div class='{$id}";
        if (isset($this->options['class'])) {
            $page .= " {$this->options['class']}";
            unset($this->options['class']);
        }
        $page .= "'";
        foreach ($this->options as $key => $value) {
            $page .= " {$key}='{$value}'";
        }
        $page .= ">";
        return $page;
    }
}
