<?php

namespace onespace\tools\widgets\ui\banner;

use onespace\tools\widgets\ui\banner\base\BannerTemplate;
use onespace\tools\widgets\ui\banner\base\TopBanner;
use onespace\tools\widgets\ui\base\Align;

final class BannerGeneralHeader extends TopBanner implements BannerTemplate {

    /**
     * The text title to place into the header
     * 
     * @var string  $title
     * 
     * @access  public
     */

    public string $title;

    /**
     * The alignment of the parsed title.
     * 
     * @var Align   $title_align    Default: Align::LEFT
     * 
     * @access  public
     */

    public Align $title_align = Align::LEFT;

    /**
     * Any links to place in a top narrow banner.
     * 
     * @var array   $links
     * 
     * @access  public
     */

    public array $links;

    /**
     * The alignment of the parsed links.
     * 
     * @var Align   $links_align    Default: Align::RIGHT
     * 
     * @access  public
     */

    public Align $links_align = Align::RIGHT;


    /**
     * {@inheritdoc}
     * 
     * @return string
     * 
     * @access  public
     */

    public function run(): string {
        $bar = parent::run();
        if (isset($this->container_class)) {
            $bar .= " {$this->container_class}";
        }
        $bar .= " title-banner narrow-banner'>";
        $bar .= "<div class='ui-text-header {$this->title_align->get_class()}'>";
        if (isset($this->title)) {
            $bar .= $this->title;
        } else {
            $bar .= "&nbsp;";
        }
        $bar .= "</div>";

        if (isset($this->links)) {
            foreach ($this->links as &$link) {
                $link = "<span>{$link}</span>";
            }
            $links = implode('', $this->links);
            $bar .= "<div class='ui-text-links {$this->links_align->get_class()}'>{$links}</div>";
        }

        $bar .= "</div>"; // container
        return $bar;
    }


    /**
     * {@inheritdoc}
     * 
     * @return string
     * 
     * @access  public
     */

    public function banner_css(): string {
        return $this->minify_css(file_get_contents(__DIR__ . '/css/general-header.css'));
    }
}
