<?php

namespace onespace\tools\widgets\ui;

use Exception;
use onespace\tools\widgets\ui\base\ImgBase;
use Yii;

/**
 * Returns the logged in user's profile picture, as a link if desired.
 * 
 * @author  Gareth Palmer <gareth@one-space.co.za>
 */

class ProfilePic extends ImgBase {

    /**
     * The full namespace and class name of the user model class.
     * Options:
     * - app\models\User
     * - common\models\User
     * 
     * @var string  $userClass
     * 
     * @access  public
     */

    public string $userClass;

    /**
     * {@inheritdoc}
     * 
     * @throws  Exception   If no User model class is defined
     */

    public function init(): void {
        parent::init();

        if (!isset($this->userClass) || !class_exists($this->userClass)) {
            throw new Exception("No User Class defined");
        }
    }

    /**
     * {@inheritdoc}
     * 
     * @return string
     */

    public function run(): string {
        parent::run();

        $user = $this->userClass::findOne(['id' => Yii::$app->user->id]);
        $link = Yii::$app->params['serviceUrls']['userUi'] . 'avatar/' . $user->dynamics_guid;

        return $this->create_img_html($link);
    }
}
