<?php

namespace onespace\tools\widgets\ui;

use onespace\tools\widgets\ui\base\PanelBase;

/**
 * Widget for generating a general page outline and container divs.
 * 
 * @author  Gareth Palmer <gareth@one-space.co.za>
 */

final class Page extends PanelBase {

    /**
     * The elements to put onto the page. Parse html, widgets, $this->render or even just a plain string.
     * 
     * @var array   $elements
     */

    public array $elements;

    /**
     * If the page is a resident portal formatted page.
     *
     * @var boolean Default: true
     * 
     * @access  public
     */

    public bool $rp = true;

    /**
     * The banner to put on the top of the page in the `content-header`.
     * 
     * @var string  $banner
     * 
     * @access  public
     */

    public string $banner;

    /**
     * The padding underneath the the top banner.
     * 
     * @var string  $banner_padding Default: 0
     * 
     * @access  public
     */

    public string $banner_padding = '0';


    /**
     * {@inheritdoc}
     * 
     * @access  public
     */

    public function init(): void {
        parent::init();

        $view = $this->getView();
        $view->blocks['rp'] = $this->rp;
        $view->params['padding-top'] ??= $this->banner_padding;

        if (isset($this->banner)) {
            $view->blocks['content-header'] = $this->banner;
        }
        $this->elements ??= [];
    }


    /**
     * {@inheritdoc}
     * 
     * @return  string
     */

    public function run(): string {
        $page = parent::run();
        $page .= $this->set_main_div('ui-page');

        foreach ($this->elements as $element) {
            $page .= $element;
        }

        $page .= "</div>"; // ui-page

        return $page;
    }
}
