<?php

namespace onespace\tools\widgets\ui;

use Yii;
use yii\base\Widget;
use yii\helpers\Html;

final class BounceLoading extends Widget {

    public string $id;

    private string $logo;
    private string $altAppName;

    public function init(): void {
        parent::init();

        $this->id ??= str_replace('-', '_', Yii::$app->security->generateRandomString(8));

        $app = Yii::$app->request->cookies->getValue('_app', 'Default');
        if ($app == 'Cloudsecure') {
            $this->logo = 'CloudSecureIcon.png';
            $this->altAppName = $app;
        } else {
            $name = Yii::$app->name;
            $altAppMap = ['gatebook 2.0' => 'Gatebook', 'gatebook 1.0' => 'Gatebook', 'onespace' => 'OneSpace'];
            $this->logo = 'onespaceIcon-Inverse.svg';
            $this->altAppName = $altAppMap[strtolower($name)] ?? '';
        }
    }


    public function run(): string {
        parent::run();
        $img = Html::img("@web/img/$this->logo", ['alt' => "$this->altAppName",'height'=>'55%','style'=>'margin-left: -6%;']);
        return <<<HTML
        <div class='loading-block' id="{$this->id}">
            <div class="pace pace-active">
                <div class="pace-progress" data-progress="50" data-progress-text="50%"
                    style="-webkit-transform: translate3d(50%, 0px, 0px); -ms-transform: translate3d(50%, 0px, 0px); transform: translate3d(50%, 0px, 0px);">
                    <div class="pace-progress-inner"></div>
                </div>
                <div class="pace-activity">
                    $img
                </div>
            </div>
        </div>
        HTML;
    }
}
