var editor = ace.edit("editor");
editor.getSession().setMode({
    path: `ace/mode/${ext}`,
    inline: true
});
//editor.setTheme("ace/theme/twilight"); //Dark Theme
editor.setShowPrintMargin(false); // Hide the vertical ruler
function ace_commend(cmd) {
    editor.commands.exec(cmd, editor);
}
editor.commands.addCommands([{
    name: 'save',
    bindKey: {
        win: 'Ctrl-S',
        mac: 'Command-S'
    },
    exec: function (editor) {
        edit_save(this, 'ace');
    }
}]);

function renderThemeMode() {
    var $modeEl = $("select#js-ace-mode"),
        $themeEl = $("select#js-ace-theme"),
        $fontSizeEl = $("select#js-ace-fontSize"),
        optionNode = function (type, arr) {
            var $Option = "";
            $.each(arr, function (i, val) {
                $Option += "<option value='" + type + i + "'>" + val + "</option>";
            });
            return $Option;
        },
        _data = {
            "aceTheme": {
                "bright": {
                    "chrome": "Chrome",
                    "clouds": "Clouds",
                    "crimson_editor": "Crimson Editor",
                    "dawn": "Dawn",
                    "dreamweaver": "Dreamweaver",
                    "eclipse": "Eclipse",
                    "github": "GitHub",
                    "iplastic": "IPlastic",
                    "solarized_light": "Solarized Light",
                    "textmate": "TextMate",
                    "tomorrow": "Tomorrow",
                    "xcode": "XCode",
                    "kuroir": "Kuroir",
                    "katzenmilch": "KatzenMilch",
                    "sqlserver": "SQL Server"
                },
                "dark": {
                    "ambiance": "Ambiance",
                    "chaos": "Chaos",
                    "clouds_midnight": "Clouds Midnight",
                    "dracula": "Dracula",
                    "cobalt": "Cobalt",
                    "gruvbox": "Gruvbox",
                    "gob": "Green on Black",
                    "idle_fingers": "idle Fingers",
                    "kr_theme": "krTheme",
                    "merbivore": "Merbivore",
                    "merbivore_soft": "Merbivore Soft",
                    "mono_industrial": "Mono Industrial",
                    "monokai": "Monokai",
                    "pastel_on_dark": "Pastel on dark",
                    "solarized_dark": "Solarized Dark",
                    "terminal": "Terminal",
                    "tomorrow_night": "Tomorrow Night",
                    "tomorrow_night_blue": "Tomorrow Night Blue",
                    "tomorrow_night_bright": "Tomorrow Night Bright",
                    "tomorrow_night_eighties": "Tomorrow Night 80s",
                    "twilight": "Twilight",
                    "vibrant_ink": "Vibrant Ink"
                }
            },
            "aceMode": {
                "javascript": "JavaScript",
                "abap": "ABAP",
                "abc": "ABC",
                "actionscript": "ActionScript",
                "ada": "ADA",
                "apache_conf": "Apache Conf",
                "asciidoc": "AsciiDoc",
                "asl": "ASL",
                "assembly_x86": "Assembly x86",
                "autohotkey": "AutoHotKey",
                "apex": "Apex",
                "batchfile": "BatchFile",
                "bro": "Bro",
                "c_cpp": "C and C++",
                "c9search": "C9Search",
                "cirru": "Cirru",
                "clojure": "Clojure",
                "cobol": "Cobol",
                "coffee": "CoffeeScript",
                "coldfusion": "ColdFusion",
                "csharp": "C#",
                "csound_document": "Csound Document",
                "csound_orchestra": "Csound",
                "csound_score": "Csound Score",
                "css": "CSS",
                "curly": "Curly",
                "d": "D",
                "dart": "Dart",
                "diff": "Diff",
                "dockerfile": "Dockerfile",
                "dot": "Dot",
                "drools": "Drools",
                "edifact": "Edifact",
                "eiffel": "Eiffel",
                "ejs": "EJS",
                "elixir": "Elixir",
                "elm": "Elm",
                "erlang": "Erlang",
                "forth": "Forth",
                "fortran": "Fortran",
                "fsharp": "FSharp",
                "fsl": "FSL",
                "ftl": "FreeMarker",
                "gcode": "Gcode",
                "gherkin": "Gherkin",
                "gitignore": "Gitignore",
                "glsl": "Glsl",
                "gobstones": "Gobstones",
                "golang": "Go",
                "graphqlschema": "GraphQLSchema",
                "groovy": "Groovy",
                "haml": "HAML",
                "handlebars": "Handlebars",
                "haskell": "Haskell",
                "haskell_cabal": "Haskell Cabal",
                "haxe": "haXe",
                "hjson": "Hjson",
                "html": "HTML",
                "html_elixir": "HTML (Elixir)",
                "html_ruby": "HTML (Ruby)",
                "ini": "INI",
                "io": "Io",
                "jack": "Jack",
                "jade": "Jade",
                "java": "Java",
                "json": "JSON",
                "jsoniq": "JSONiq",
                "jsp": "JSP",
                "jssm": "JSSM",
                "jsx": "JSX",
                "julia": "Julia",
                "kotlin": "Kotlin",
                "latex": "LaTeX",
                "less": "LESS",
                "liquid": "Liquid",
                "lisp": "Lisp",
                "livescript": "LiveScript",
                "logiql": "LogiQL",
                "lsl": "LSL",
                "lua": "Lua",
                "luapage": "LuaPage",
                "lucene": "Lucene",
                "makefile": "Makefile",
                "markdown": "Markdown",
                "mask": "Mask",
                "matlab": "MATLAB",
                "maze": "Maze",
                "mel": "MEL",
                "mixal": "MIXAL",
                "mushcode": "MUSHCode",
                "mysql": "MySQL",
                "nix": "Nix",
                "nsis": "NSIS",
                "objectivec": "Objective-C",
                "ocaml": "OCaml",
                "pascal": "Pascal",
                "perl": "Perl",
                "perl6": "Perl 6",
                "pgsql": "pgSQL",
                "php_laravel_blade": "PHP (Blade Template)",
                "php": "PHP",
                "puppet": "Puppet",
                "pig": "Pig",
                "powershell": "Powershell",
                "praat": "Praat",
                "prolog": "Prolog",
                "properties": "Properties",
                "protobuf": "Protobuf",
                "python": "Python",
                "r": "R",
                "razor": "Razor",
                "rdoc": "RDoc",
                "red": "Red",
                "rhtml": "RHTML",
                "rst": "RST",
                "ruby": "Ruby",
                "rust": "Rust",
                "sass": "SASS",
                "scad": "SCAD",
                "scala": "Scala",
                "scheme": "Scheme",
                "scss": "SCSS",
                "sh": "SH",
                "sjs": "SJS",
                "slim": "Slim",
                "smarty": "Smarty",
                "snippets": "snippets",
                "soy_template": "Soy Template",
                "space": "Space",
                "sql": "SQL",
                "sqlserver": "SQLServer",
                "stylus": "Stylus",
                "svg": "SVG",
                "swift": "Swift",
                "tcl": "Tcl",
                "terraform": "Terraform",
                "tex": "Tex",
                "text": "Text",
                "textile": "Textile",
                "toml": "Toml",
                "tsx": "TSX",
                "twig": "Twig",
                "typescript": "Typescript",
                "vala": "Vala",
                "vbscript": "VBScript",
                "velocity": "Velocity",
                "verilog": "Verilog",
                "vhdl": "VHDL",
                "visualforce": "Visualforce",
                "wollok": "Wollok",
                "xml": "XML",
                "xquery": "XQuery",
                "yaml": "YAML",
                "django": "Django"
            },
            "fontSize": {
                8: 8,
                10: 10,
                11: 11,
                12: 12,
                13: 13,
                14: 14,
                15: 15,
                16: 16,
                17: 17,
                18: 18,
                20: 20,
                22: 22,
                24: 24,
                26: 26,
                30: 30
            }
        };
    if (_data && _data.aceMode) {
        $modeEl.html(optionNode("ace/mode/", _data.aceMode));
    }
    if (_data && _data.aceTheme) {
        var lightTheme = optionNode("ace/theme/", _data.aceTheme.bright),
            darkTheme = optionNode("ace/theme/", _data.aceTheme.dark);
        $themeEl.html("<optgroup label=\"Bright\">" + lightTheme + "</optgroup><optgroup label=\"Dark\">" + darkTheme + "</optgroup>");
    }
    if (_data && _data.fontSize) {
        $fontSizeEl.html(optionNode("", _data.fontSize));
    }
    $modeEl.val(editor.getSession().$modeId);
    $themeEl.val(editor.getTheme());
    $fontSizeEl.val(12).change(); //set default font size in drop down
}

$(function () {
    renderThemeMode();
    $(".js-ace-toolbar").on("click", 'button', function (e) {
        e.preventDefault();
        let cmdValue = $(this).attr("data-cmd"),
            editorOption = $(this).attr("data-option");
        if (cmdValue && cmdValue != "none") {
            ace_commend(cmdValue);
        } else if (editorOption) {
            if (editorOption == "fullscreen") {
                (void 0 !== document.fullScreenElement && null === document.fullScreenElement || void 0 !== document.msFullscreenElement && null === document.msFullscreenElement || void 0 !== document.mozFullScreen && !document.mozFullScreen || void 0 !== document.webkitIsFullScreen && !document.webkitIsFullScreen) &&
                    (editor.container.requestFullScreen ? editor.container.requestFullScreen() : editor.container.mozRequestFullScreen ? editor.container.mozRequestFullScreen() : editor.container.webkitRequestFullScreen ? editor.container.webkitRequestFullScreen(Element.ALLOW_KEYBOARD_INPUT) : editor.container.msRequestFullscreen && editor.container.msRequestFullscreen());
            } else if (editorOption == "wrap") {
                let wrapStatus = (editor.getSession().getUseWrapMode()) ? false : true;
                editor.getSession().setUseWrapMode(wrapStatus);
            }
        }
    });
    $("select#js-ace-mode, select#js-ace-theme, select#js-ace-fontSize").on("change", function (e) {
        e.preventDefault();
        let selectedValue = $(this).val(),
            selectionType = $(this).attr("data-type");
        if (selectedValue && selectionType == "mode") {
            editor.getSession().setMode(selectedValue);
        } else if (selectedValue && selectionType == "theme") {
            editor.setTheme(selectedValue);
        } else if (selectedValue && selectionType == "fontSize") {
            editor.setFontSize(parseInt(selectedValue));
        }
    });
});