<?php

namespace onespace\tools\widgets\loaders;

use onespace\tools\widgets\icons\FontAwesomeIcon6;
use yii\helpers\Html;

abstract class BaseIconLoader extends \yii\base\Widget {

    public const SIZE_SMALL  = 'small';
    public const SIZE_MEDIUM = 'medium';
    public const SIZE_LARGE  = 'large';

    public string $size = self::SIZE_SMALL;
    /** @see vendor/onespace/yii2-widgets/src/widgets/icons/base/Icon.php `VALID_COLOURS` */
    public string $colour;


    protected array $widget;
    protected string $textSize;


    /**
     * {@inheritdoc}
     */

    public function init() {
        $this->widget = [
            'content' => '',
            'options' => ['class' => 'fa-spin'],
        ];

        if (isset($this->colour)) {
            $this->widget['colour'] = $this->colour;
        }

        $this->textSize = match ($this->size) {
            self::SIZE_SMALL  => '1.5rem',
            self::SIZE_MEDIUM => '3.0rem',
            self::SIZE_LARGE  => '15rem',
        };
    }


    /**
     * {@inheritdoc}
     */

    public function run(): string {
        return Html::tag(
            'p',
            FontAwesomeIcon6::widget($this->widget),
            ['style' => "display: inline-block; font-size: {$this->textSize};"],
        );
    }
}
