## Assets

- ApexChartsAsset
- ChartJSAsset
- FontAwsome5Asset
- FontAwsome6Asset
- MapAsset
- OSWidgetsAsset
- TinyMCEAsset

## Components

### AzureDB

Tools for connecting to the Azure Besecure DB.

| Key | Value |
| --- | ----- |
| Namespace | `onespace\tools\components\azuredb` |
| Files | `validators\AzureExistValidator.php` |
| | `validators\AzureUniqueValidator.php` |
| | `ActiveQuery.php` |
| | `AzureActiveRecord.php` |
| | `Command.php` |
| | `Connection.php` |
| | `DataReader.php` |
| | `Query.php` |
| | `QueryBuilder.php` |
| Status | Functional |

### TDEngine

Tools for connecting to the TD Engine timeseries DB.

| Key | Value |
| --- | ----- |
| Namespace | `onespace\tools\components\tdengine` |
| Files | `ActiveQuery.php` |
| | `ActiveQuery.php` |
| | `Command.php` |
| | `Connection.php` |
| | `Query.php` |
| | `QueryBuilder.php` |
| | `Schema.php` |
| | `TDEngineActiveRecord.php` |
| Status | Mostly Functional |

### Rabbit

Helping tools for working with and for RabbitMQ.

| Key | Value |
| --- | ----- |
| Namespace | `onespace\tools\components` |
| Files | `Rabbit.php` |
| Status | Needs testing |

---

## Helpers

### Enum Helpers

#### UnbackedHelper

Trait for providing tools to unbacked ENUMS.

`use \onespace\tools\helpers\enum\UnbackedHelper;`

### Spreadsheet Helpers

Traits for assisting with helping working with spreadsheets.

- CSVLoader
- ExcelLoader

#### CSVLoader

Trait for assisting with CSV files.

`use \onespace\tools\helpers\traits\CSVLoader;`

#### ExcelLoader

Trait for assisting with Excel (.xlsx) files.

`use \onespace\tools\helpers\traits\ExcelLoader;`

### Terminal Helpers

- TerminalFeedback

#### TerminalFeedback

Tool for assist with various Terminal tasks. Specifically for showing progress as a large number of records are being processed.

`use \onespace\tools\helpers\traits\TerminalFeedback;`

### General Helpers

- GetView
- Position

#### GetView

Trait for assisting with getting the `View`, mainly within the context of a static method.

`use \onespace\tools\helpers\traits\GetView;`

#### Position

Future ENUM (currently a standard class) for indicating the position of various items on the screen.

`use \onespace\tools\helpers\Position;`

---

## Widgets

### Charts

- ApexCharts
- ChartJS

#### ApexCharts

Widget for drawing charts using [APEX CHARTS](https://apexcharts.com).

__Docs:__ [https://apexcharts.com/docs/](https://apexcharts.com/docs/)

`use \onespace\tools\widgets\ApexCharts\ApexCharts;`

| Key | Type | Default |
| --- | ---- | ------- |
| `options` | array | |
| `deferLoading` | bool | false |
| `id` | string | |

#### ChartJS

Widget for drawing charts using [ChartJS](https://www.chartjs.org).

__Docs:__ [https://www.chartjs.org](https://www.chartjs.org)

`use \onespace\tools\widgets\chartjs\ChartJs;`

| Key | Type | Default |
| --- | ---- | ------- |
| id | string | |
| jsLoad | int | \yii\web\View::POS_READY |
| data | array\|string | `[]` |

### Calendars

- FullCalendar

#### FullCalendar

Widget for drawing calendar using the tool [FullCalendar](https://fullcalendar.io)

__Docs:__ [https://fullcalendar.io/docs](https://fullcalendar.io/docs)

`use \onespace\tools\widgets\calendar\FullCalendar;`

| Key | Type | Default |
| --- | ---- | ------- |
| options | array | |
| events | array | `[]` |
| eventSources | array | `[]` |
| initialView | string | `dayGridMonth` |
| navLinks | bool | true |
| header_layout | array | `['start' => 'prev,next today', 'center' => 'title', 'end' => 'dayGridMonth timeGridWeek timeGridOneDay listWeek' ]` |
| params_overwrite | string\|array | |
| modal | string | |
| custom_click_event | string | |
| eventName | string | `event` |

### File Uploading

- Dropzone
- ImageConverterFileInput

#### Dropzone

Widget for creating [Dropzone](https://www.dropzone.dev) file uploader.

__Docs:__ [https://docs.dropzone.dev](https://docs.dropzone.dev)

| Key | Type | Default |
| --- | ---- | ------- |
| id | string | |
| action | string | |
| chunking | bool | true |
| chunkSize | int | 2000000 |
| forceChunking | bool | false |
| retryChunks | bool | false |
| retryChunksLimit | int | 3 |
| parallelUploads | int | 3 |
| parallelChunkUploads | bool | false |
| timeout | int | 120000 |
| maxFilesize | int | 5000000000 |
| maxFiles | int\|null | null |
| acceptedFiles | string\|null | null |
| options | array | `[]` |
| hiddenInputs | array | `[]` |
| useForm | bool | true |
| hook | string | |
| debug | bool | |
| csrf | string | '_csrf' |

#### ImageConverterFileInput

Self build widget for handling drag and drop, as well as file type conversion for image uploading. Can convert an image from .jpg or .png to .webp, all on the browser.

| Key | Type | Default |
| --- | ---- | ------- |
| maxWidth | int\|null | null |
| maxHeight | int\|null | null |
| showPreview | bool | true |
| includeFormControl | bool | false |
| accept | string | 'image/*' |
| imgId | string | |
| form | \yii\bootstrap\ActiveForm | |
| layout | int | 0 |

### WYSIWYG

- GrapeJS
- TinyMCE

#### GrapeJS

Widget for using the WYSIWYG fancy editor [GrapeJS](https://grapesjs.com)

__Docs:__ [https://grapesjs.com/docs/](https://grapesjs.com/docs/)

| Key | Type | Default |
| --- | ---- | ------- |
| isNewsletter | bool | false |
| height | string | |
| width | string | |
| content | string | `''` |
| jsonContent | string\|array\|false | false |
| fromElement | bool | true |
| customLoadScript | string | |
| extraScripts | string | |
| customStyles | string | |
| storageType | int | |
| storageKey | string | |
| options | array | `[]` |
| id | string | |
| debug | bool | false |

#### TinyMCE

Widget for using the WYSIWYG fancy editor [TinyMCE](https://www.tiny.cloud/tinymce/)

__Docs:__ [https://www.tiny.cloud/docs/tinymce/latest/](https://www.tiny.cloud/docs/tinymce/latest/)


| Key | Type | Default |
| --- | ---- | ------- |
| menubar | string | 'file edit view insert format table' |
| toolbar | string | 'undo redo \| blocks \| bold italic underline strikethrough \| alignleft aligncenter alignright alignjustify \| fontfamily \| bullist numlist outdent indent \| link unlink image \| wordcount charmap emoticons removeformat hr' |
| plugins | string | 'advlist autolink lists link image charmap preview anchor pagebreak table media wordcount charmap emoticons' |
| fonts | array | `[...Too long for this table...]` |
| fontCss | string\|null | null |
| uploadImages | bool | true |

### Icons

- FA5
- FA6
- Glyphicons

### HTML Input

- DateSelector
- DuelDateSelector
- DuelListBox

### Loaders

- DotLoader
- LineSpinLoader
- SnipperLoader
- TextLoader

### File Browsing

- TinyFileBrowser

### Maps

- GoogleMaps

### Misc

- Luminance
- UI Stuff
