<?php

namespace onespace\widgets\ui\panels;

enum PanelSizes {
    case FIFTY_FIFTY;
    case TWENTYFIVE_SEVENTYFIVE;
    case SEVENTYFIVE_TWENTYFIVE;
    case ONETHIRD_TWOTHIRDS;
    case TWOTHIRDS_ONETHIRD;

    public function id(): int {
        return match ($this) {
            self::FIFTY_FIFTY => 0,
            self::TWENTYFIVE_SEVENTYFIVE => 1,
            self::SEVENTYFIVE_TWENTYFIVE => 2,
            self::ONETHIRD_TWOTHIRDS => 2,
            self::TWOTHIRDS_ONETHIRD => 2,
        };
    }

    public function panelClass(bool $resizable = false): string {
        return ' ' . match ($this) {
            self::FIFTY_FIFTY             => $resizable ? 'ui-panel-0r-template' : 'ui-panel-0-template',
            self::TWENTYFIVE_SEVENTYFIVE  => $resizable ? 'ui-panel-1r-template' : 'ui-panel-1-template',
            self::SEVENTYFIVE_TWENTYFIVE  => $resizable ? 'ui-panel-2r-template' : 'ui-panel-2-template',
            self::ONETHIRD_TWOTHIRDS      => $resizable ? 'ui-panel-3r-template' : 'ui-panel-3-template',
            self::TWOTHIRDS_ONETHIRD      => $resizable ? 'ui-panel-4r-template' : 'ui-panel-4-template',
        };
    }
}
