<?php

namespace onespace\widgets\ui\banner;

use onespace\widgets\ui\banner\base\EstatesBaseBanner;

/**
 * Estate banner with the user's estates, in the context of a user being both an estate
 * manager and a erf owner, which may be on a seperate estate.
 * 
 * @author  Gareth Palmer <gareth@one-space.co.za>
 */

final class BannerEstatesBoth extends EstatesBaseBanner {

    /**
     * {@inheritdoc}
     * 
     * @return  string
     * 
     * @access  public
     */

    public function run(): string {
        $this->type = 'both';
        return parent::run();
    }
}
