<?php

namespace onespace\widgets\icons\base;

use yii\bootstrap\Widget;

/**
 * Base widget generation class, with common properties across the icon widgets.
 * 
 * @author  Jason Phillips <Jason@one-space.co.za>
 */

class Icon extends Widget {
    protected $baseClass = '';
    protected $defaultIdentifier = '';


    public $validColours = [
        'light-blue',
        'aqua',
        'green',
        'yellow',
        'red',
        'gray',
        'navy',
        'teal',
        'purple',
        'orange',
        'maroon',
        'black'
    ];

    public $colour;
    public $identifier;
    public $content = '&nbsp;';

    private $colourClass;

    public function init() {
        parent::init();

        if ($this->colour != null) {
            if (in_array($this->colour, $this->validColours)) {
                $this->colourClass = ' text-' . $this->colour;
            }
        }

        if ($this->identifier == null) {
            $this->identifier = $this->defaultIdentifier;
        }
    }

    public function run() {
        // If user has configured the class option, add those classes to the required ones
        $appendClass = isset($this->options['class']) ? ' ' . $this->options['class'] : '';
        $this->options['class'] = $this->baseClass . $this->identifier . $this->colourClass . $appendClass;
        return \yii\helpers\Html::tag(
            'i',
            $this->content,
            $this->options
        );
    }
}
