<?php

namespace onespace\widgets\tinyfilebrowser\traits;

use Yii;
use yii\web\View;

trait FMPageElements {

    /**
     * Show Header after login
     */
    protected function fm_show_header(): string {
        $this->print_external('pre-jsdelivr');
        $this->print_external('pre-cloudflare');
        // $this->print_external('css-bootstrap');
        $this->print_external('css-font-awesome');
        if (FM_USE_HIGHLIGHTJS && isset($_GET['view'])) {
            $this->print_external('css-highlightjs');
        }

        // $this->view->registerJs(<<<JS
        // window.csrf = "{$_SESSION['token']}";
        // JS);

        $this->view->registerCss(file_get_contents(__DIR__ . '/../css/show_header.css'));
        if (FM_THEME == "dark") {
            $this->view->registerCss(file_get_contents(__DIR__ . '/../css/show_header_dark.css'));
        }

        $html = '';
        $html .= '<div id="wrapper" class="container-fluid">';

        $html .= $this->new_item_modal();
        // $html .= $this->advanced_search_modal();
        $html .= $this->rename_modal();
        $html .= $this->confirm_modal();
        return $html;
    }


    private function new_item_modal(): string {
        $html = '';
        $html .= '<div class="modal fade" id="createNewItem" tabindex="-1" role="dialog" data-bs-backdrop="static" data-bs-keyboard="false" aria-labelledby="newItemModalLabel" aria-hidden="true">';
        $html .= '<div class="modal-dialog" role="document">';
        $html .= "<form class='modal-content {$this->fm_get_theme()}' method='post'>";
        $html .= '<div class="modal-header">';
        $html .= "<h4 class='modal-title' id='newItemModalLabel'><i class='fa fa-plus-square fa-fw'></i>{$this->lng('CreateNewItem')}</h4>";
        $html .= '<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>';
        $html .= '</div>';
        $html .= '<div class="modal-body">';
        // $html .= "<p><label for='newfile'>{$this->lng('ItemType')}</label></p>";
        // $html .= '<div class="radio">';
        // $html .= '<label>';
        // $html .= '<input type="radio" name="newfile" id="customRadioInline1" value="file">';
        // $html .= "{$this->lng('File')}";
        // $html .= '</label>';
        // $html .= '</div>';
        // $html .= '<div class="radio">';
        // $html .= '<label>';
        // $html .= '<input type="radio" name="newfile" id="customRadioInline2" value="folder" checked>';
        // $html .= "{$this->lng('Folder')}";
        // $html .= '</label>';
        // $html .= '</div>';

        $html .= "<p class='mt-3'><label for='newfilename'>New Folder Name&nbsp;</label></p>";
        $html .= "<input type='text' name='newfilename' id='newfilename' value='' class='form-control' placeholder='{$this->lng('Enter here...')}' required>";
        $html .= '</div>';
        $html .= '<div class="modal-footer">';
        $csrf = Yii::$app->request->csrfToken;
        $html .= "<input type='hidden' name='new_dir' value='{$this->ftp_path}'>";
        $html .= "<input type='hidden' name='_csrf' value='{$csrf}'>";
        $html .= "<input type='hidden' name='token' value='{$_SESSION['token']}'>";
        $html .= "<button type='button' class='btn btn-default' data-dismiss='modal'>";
        $html .= "<i class='fa fa-times-circle'></i>&nbsp;{$this->lng('Cancel')}</button>";
        $html .= '<button type="submit" class="btn btn-success">';
        $html .= "<i class='fa fa-check-circle'></i>&nbsp;{$this->lng('CreateNow')}</button>";
        $html .= '</div>';
        $html .= '</form>';
        $html .= '</div>';
        $html .= '</div>';
        return $html;
    }


    private function advanced_search_modal(): string {
        $html = '';
        $html .= '<div class="modal fade" id="searchModal" tabindex="-1" role="dialog" aria-labelledby="searchModalLabel" aria-hidden="true">';
        $html .= '<div class="modal-dialog modal-lg" role="document">';
        $html .= "<div class='modal-content {$this->fm_get_theme()}'>";
        $html .= '<div class="modal-header">';
        $html .= '<h5 class="modal-title col-10" id="searchModalLabel">';
        $html .= '<div class="input-group mb-3">';
        $html .= "<input type='text' class='form-control' placeholder='{$this->lng('Search')} {$this->lng('a files')}' aria-label='{$this->lng('Search')}' aria-describedby='search-addon3' id='advanced-search' autofocus required>";
        $html .= '<span class="input-group-text" id="search-addon3"><i class="fa fa-search"></i></span>';
        $html .= '</div>';
        $html .= '</h5>';
        $html .= '<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>';
        $html .= '</div>';
        $html .= '<div class="modal-body">';
        $html .= '<form action="" method="post">';
        $html .= '<div class="lds-facebook">';
        $html .= '<div></div>';
        $html .= '<div></div>';
        $html .= '<div></div>';
        $html .= '</div>';
        $html .= '<ul id="search-wrapper">';
        $html .= "<p class='m-2'>{$this->lng('Search file in folder and subfolders...')}</p>";
        $html .= '</ul>';
        $html .= '</form>';
        $html .= '</div>';
        $html .= '</div>';
        $html .= '</div>';
        $html .= '</div>';
        return $html;
    }


    private function rename_modal(): string {
        $html = '';
        $html .= '<div class="modal modal-alert" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" role="dialog" id="renameDailog">';
        $html .= '<div class="modal-dialog" role="document">';
        $html .= "<form class='modal-content rounded-3 shadow {$this->fm_get_theme()}' method='post' autocomplete='off'>";
        $html .= '<div class="modal-body p-4 text-center">';
        $html .= "<h5 class='mb-3'>{$this->lng('Are you sure want to rename?')}</h5>";
        $html .= '<p class="mb-1">';
        $html .= "<input type='text' name='rename_to' id='js-rename-to' class='form-control' placeholder='{$this->lng('Enter new file name')}' required>";
        $csrf = Yii::$app->request->csrfToken;
        $html .= "<input type='hidden' name='_csrf' value='{$csrf}'>";
        $html .= "<input type='hidden' name='token' value='{$_SESSION['token']}'>";
        $html .= '<input type="hidden" name="rename_from" id="js-rename-from">';
        $html .= '<input type="hidden" name="rename_path" id="js-rename-path">';
        $html .= '</p>';
        $html .= '</div>';
        $html .= '<div class="modal-footer flex-nowrap p-0">';
        $html .= "<button type='button' class='btn btn-lg btn-link fs-6 text-decoration-none col-6 m-0 rounded-0 border-end' data-dismiss='modal'>{$this->lng('Cancel')}</button>";
        $html .= "<button type='submit' class='btn btn-lg btn-link fs-6 text-decoration-none col-6 m-0 rounded-0'><strong>{$this->lng('Okay')}</strong></button>";
        $html .= '</div>';
        $html .= '</form>';
        $html .= '</div>';
        $html .= '</div>';
        return $html;
    }


    private function confirm_modal(): string {
        $html = '';
        $html .= '<script type="text/html" id="js-tpl-confirm">';
        $html .= '<div class="modal modal-alert confirmDailog" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" role="dialog" id="confirmDailog-<%this.id%>">';
        $html .= '<div class="modal-dialog" role="document">';
        $html .= "<form class='modal-content rounded-3 shadow {$this->fm_get_theme()}' method='post' autocomplete='off' action='<%this.action%>'>";
        $html .= '<div class="modal-body p-4 text-center">';
        $html .= "<h5 class='mb-2'>{{$this->lng('Are you sure want to')} <%this.title%> ?</h5>";
        $html .= '<p class="mb-1"><%this.content%></p>';
        $html .= '</div>';
        $html .= '<div class="modal-footer flex-nowrap p-0">';
        $html .= "<button type='button' class='btn btn-lg btn-link fs-6 text-decoration-none col-6 m-0 rounded-0 border-end' data-bs-dismiss='modal'>{$this->lng('Cancel')}</button>";
        $html .= "<input type='hidden' name='token' value='{$_SESSION['token']}'>";
        $html .= "<button type='submit' class='btn btn-lg btn-link fs-6 text-decoration-none col-6 m-0 rounded-0' data-bs-dismiss='modal'><strong>{$this->lng('Okay')}</strong></button>";
        $html .= '</div>';
        $html .= '</form>';
        $html .= '</div>';
        $html .= '</div>';
        $html .= '</script>';
        return $html;
    }


    /**
     * Show page footer after login
     */
    protected function fm_show_footer() {
        $html = '';
        $html .= '</div>';
        $this->print_external('js-jquery');
        $this->print_external('js-bootstrap');
        $this->print_external('js-jquery-datatables');
        if (FM_USE_HIGHLIGHTJS && isset($_GET['view'])) {
            $this->print_external('js-highlightjs');
            $this->view->registerJs(<<<JS
            hljs.highlightAll();
            var isHighlightingEnabled = true;
            JS);
        }

        // $this->view->registerJs(file_get_contents(__DIR__ . '/../js/show_footer.js'), View::POS_END);
        if (isset($_GET['edit']) && isset($_GET['env']) && FM_EDIT_FILE && !FM_READONLY) {
            $ext = pathinfo($_GET["edit"], PATHINFO_EXTENSION);
            $ext =  $ext == "js" ? "javascript" :  $ext;
            $this->print_external('js-ace');
            $this->view->registerJs(<<<JS
            const ext = $ext;
            JS);
            $this->view->registerJs(file_get_contents(__DIR__ . '/../js/ace_editor.js'), View::POS_END);
        }
        $html .= '<div id="snackbar"></div>';
        return $html;
    }


    /**
     * Show nav block
     * @param string $path
     */
    protected function fm_show_nav_path($path) {
        global $editFile;

        $set_id = isset($_GET['id']) && !empty($_GET['id']) ? "&id={$_GET['id']}" : '';

        $html = '';
        $html .= "<nav class='navbar fm_custom_navbar'>";
        $path = $this->fm_clean_path($path);
        $root_url = "<a href='?p={$set_id}'><i class='fa fa-home' aria-hidden='true' title='" . FM_ROOT_PATH . "'></i></a>";
        $sep = '<i class="bread-crumb"> / </i>';
        if ($path != '') {
            $exploded = explode('/', $path);
            $count = count($exploded);
            $array = [];
            $parent = '';
            for ($i = 0; $i < $count; $i++) {
                $parent = trim($parent . '/' . $exploded[$i], '/');
                $parent_enc = urlencode($parent);
                $array[] = "<a href='?p={$parent_enc}{$set_id}'>" . $this->fm_enc($this->fm_convert_win($exploded[$i])) . "</a>";
            }
            $root_url .= $sep . implode($sep, $array);
        }
        $html .= "<div class='col-xs-6 col-sm-5'>{$root_url}{$editFile}</div>";

        $html .= '<div class="col-xs-6 col-sm-7">';
        if (!isset($_GET['upload'])) {
            $html .= "<ul class='navbar-nav fm_custom_navbar--right'>";
            $html .= $this->search_bar($path);
            $is_root = isset($_GET['p']) && empty($_GET['p']);
            if (!FM_READONLY && !$is_root) {
                /**
                 * UPLOAD
                 */
                $html .= '<li class="nav-item list-unstyled">';
                $site = urlencode(FM_PATH);
                $html .= "<a title='{$this->lng('Upload')}' class='nav-link' href='?p={$site}&amp;upload{$set_id}'>";
                $html .= "<i class='fa fa-cloud-upload' aria-hidden='true'></i>&nbsp;{$this->lng('Upload')}</a>";
                $html .= '</li>';
                /**
                 * CREATE NEW
                 */
                $html .= '<li class="nav-item list-unstyled">';
                $html .= "<a title='{$this->lng('NewItem')}' class='nav-link' href='#createNewItem' data-toggle='modal' data-target='#createNewItem'>";
                $html .= "<i class='fa fa-plus-square'></i>&nbsp;{$this->lng('NewItem')}</a>";
                $html .= '</li>';
            }
            $html .= '</ul>';
        }
        $html .= '</div>';
        $html .= '</nav>';

        return $html;
    }


    private function search_bar($path): string {

        $html = '';
        $html .= '<li class="nav-item mr-2 list-unstyled">';
        $html .= '<div class="input-group input-group-sm mr-1" style="margin-top:4px;">';
        $html .= "<input type='text' class='form-control' placeholder='{$this->lng('Filter')}' aria-label='{$this->lng('Search')}' aria-describedby='search-addon2' id='search-addon'>";
        $html .= '<div class="input-group-btn">';
        $html .= '<button class="btn btn-default" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class="fa fa-search"></i></button>';
        $html .= '<ul class="dropdown-menu dropdown-menu-right">';
        $set_path = $path ? $path : '.';
        $html .= "<li><a href='{$set_path}' id='js-search-modal' data-toggle='modal' data-target='#searchModal'>{$this->lng('Advanced Search')}</a></li>";
        $html .= '</ul>';
        $html .= '</div>';
        $html .= '</div>';
        $html .= '</li>';
        return $html;
    }


    /**
     * Show alert message from session
     */
    protected function fm_show_message() {
        $html = '';
        if (isset($_SESSION[FM_SESSION_ID]['message'])) {
            $class = isset($_SESSION[FM_SESSION_ID]['status']) ? $_SESSION[FM_SESSION_ID]['status'] : 'ok';
            $html .= '<p class="message ' . $class . '">' . $_SESSION[FM_SESSION_ID]['message'] . '</p>';
            unset($_SESSION[FM_SESSION_ID]['message']);
            unset($_SESSION[FM_SESSION_ID]['status']);
        }
        return $html;
    }
}
