<?php

namespace onespace\widgets;

use onespace\widgets\assets\GetView;
use Yii;
use yii\helpers\Html;
use yii\web\View;
use yii\widgets\InputWidget;

/**
 * @author  Gareth Palmer <gareth@one-space.co.za>
 * 
 * @see https://www.tiny.cloud/docs/
 * @see https://www.tiny.cloud/docs/plugins/opensource/imagetools/
 */

class TinyMCE extends InputWidget {

    use GetView;

    /**
     * @see https://www.tiny.cloud/docs/tinymce/6/available-menu-items/
     */
    public $menubar = 'file edit view insert format table';
    /**
     * @see https://www.tiny.cloud/docs/tinymce/6/available-toolbar-buttons/
     */
    public $toolbar = 'undo redo | blocks | bold italic underline strikethrough | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link unlink image | wordcount charmap emoticons removeformat hr';
    /**
     * @see https://www.tiny.cloud/docs/tinymce/6/plugins/
     */
    public $plugins = 'advlist autolink lists link image charmap preview anchor pagebreak table media wordcount charmap emoticons';

    public function init() {
        if (isset($this->model) && isset($this->attribute)) {
            $this->name = Html::getInputName($this->model, $this->attribute);
            parent::init();
            $this->id = 'mce' . str_replace('-', '_', Yii::$app->security->generateRandomString(8));
            $this->options['id'] = $this->id;
            $this->options['name'] = $this->name;
        }
    }


    /**
     * @inheritdoc
     */

    public function run(): string {
        parent::run();

        $view = self::getPageView();
        $view->registerCss(<<<CSS
            .tox-promotion,
            .tox-statusbar__branding {
                display: none;
            }
        CSS, ['position' => View::POS_HEAD]);

        $view->registerJs(<<<JS
            tinymce.init({
                selector: '#{$this->id}',
                promotion: false,
                menubar: '{$this->menubar}',
                toolbar: '{$this->toolbar}',
                plugins: '{$this->plugins}',
            });
        JS);

        return Html::activeTextarea($this->model, $this->attribute, $this->options);
    }
}
