<?php

namespace onespace\widgets\ui\base;

use onespace\widgets\icons\FontAwesomeIcon;
use Yii;
use yii\base\Widget;
use yii\helpers\ArrayHelper;
use yii\helpers\Html;

/**
 * Forms the bases of image generating widgets.
 * 
 * @author  Gareth Palmer <gareth@one-space.co.za>
 */
class ImgBase extends Widget {

    /**
     * Any `<img>` element properties to add to the `<img>` tag.
     * 
     * For example `options' => ['class' => 'myClass']` will add a class of `myClass` to
     * the `<img>` tag.
     * 
     * @var array   $options    Default: []
     * 
     * @access  public
     */

    public array $options = [];

    /**
     * Explicitly state the loading method for the `<img>`.
     * 
     * @var string  $loading    Default: lazy.
     * 
     * @access  public
     */

    public string $loading = 'lazy';

    /**
     * If you wish to wrap the image in a link, pass the desired parameters
     * for the `<a>` tag here. If empty, a link will not be created.
     * 
     * @var array   $link
     * 
     * @access  public
     */

    public array $link;

    /**
     * The Font Awesome Icons v5 identifier as a fallback image.
     * 
     * @var string  $fallback   Default: 'question'
     * 
     * @access  public
     */

    public string $fallback = 'question';


    /**
     * Return the HTML for the requested image, with a <a> link if
     * desired, according to the parsed parameters & properties.
     * 
     * @param   string  $link   The link to the image.
     * 
     * @return  string
     * 
     * @access  protected
     */

    protected function create_img_html(string $link): string {
        $img = '';

        if (isset($this->link)) {
            $img .= "<a";
            foreach ($this->link as $key => $val) {
                $img .= " {$key}='{$val}'";
            }
            $img .= ">";
        }
        $alt = '<div class="' . $this->options['class'] . '" style="color: var(--cool-grey); display: grid;place-items: center;">';
        $alt .= FontAwesomeIcon::widget([
            'identifier' => $this->fallback,
            'style' => 'solid',
            'content' => '',
            'options' => [
                'style' => 'color: var(--cool-grey);font-size: 3rem',
            ],
        ]);
        $alt .= "</div>";

        $img .= Html::img($link, ArrayHelper::merge([
            'loading' => $this->loading,
            'onerror' => "this.onerror=null; this.parentNode.innerHTML = '{$alt}'",
        ], $this->options));

        if (isset($this->link)) {
            $img .= "</a>";
        }
        return $img;
    }
}
