<?php

namespace onespace\widgets\ui\banner;

use onespace\widgets\ui\banner\base\BannerTemplate;
use onespace\widgets\ui\banner\base\TopBanner;

/**
 * Draw the top wide banner. It contains user's personal information with wide margins.
 */

final class BannerWideUserInfo extends TopBanner implements BannerTemplate {


    /**
     * @inheritdoc
     */

    public function run(): string {
        $bar = parent::run();
        $bar .= ' ui-panel general-wide-banner';
        if (isset($this->container_class)) {
            $bar .= " {$this->container_class}";
        }
        if (!isset($this->header_text)) {
            $bar .= " no-header";
        }
        $bar .= " rp-heading'>";
        if (isset($this->header_text)) {
            $bar .= "<h2 class='h2'>{$this->header_text}</h2>";
        }
        $bar .= $this->profile_pic_big();
        $bar .= $this->user_info();
        $bar .= "</div>"; // ui-userinfo-container
        return $bar;
    }


    /**
     * @inheritdoc
     */

    public function banner_css(): string {
        return $this->minify_css(<<<CSS
        .general-wide-banner {
            display: grid;
            padding: 1rem 3.5rem;
            align-items: center;
            row-gap: 0.8rem;
            grid-template-columns: 140px 1fr;
            grid-template-rows: auto;
            grid-template-areas:
                "head-text head-text"
                "profile-pic user-text";
        }

        .ui-userinfo-container.no-header {
            row-gap: unset;
            grid-template-areas:
                "profile-pic user-text";
            grid-template-rows: auto;
        }

        .rp-heading {
            padding-top: 2rem;
            padding-bottom: 2rem;
        }

        .ui-userinfo-container .h2 {
            font-size: 3.4rem;
            grid-area: head-text;
            margin-top: 0;
        }

        .profile-pic {
            grid-area: profile-pic;
            justify-self: start;
        }
        
        .profile-pic-img {
            border: 3px solid var(--main-accent);
            border-radius: 50%;
            height: 120px;
            width: 120px;
        }

        .profile-info {
            grid-area: user-text;
            color: var(--cool-grey);
        }

        .profile-info .h3 {
            color: var(--main-accent);
            margin-top: 0;
            margin-bottom: 0;
        }

        .profile-info .h3 {
            color: var(--main-accent);
            margin-top: 0;
            margin-bottom: 0;
        }

        .profile-link {
            color: var(--cool-grey);
            font-size: 1.8rem;
        }

        .profile-link:hover {
            color: #fff;
        }

        .profile-info-sub div {
            margin-top: 3px;
        }
        CSS);
    }
}
