<?php

namespace onespace\widgets\ui;

use app\models\User;
use onespace\widgets\ui\base\ImgBase;
use Yii;

/**
 * Returns the logged in user's profile picture, as a link if desired.
 * 
 * @author  Gareth Palmer <gareth@one-space.co.za>
 */

class ProfilePic extends ImgBase {

    /**
     * @inheritdoc
     */

    public function run(): string {
        parent::run();

        $user = User::findOne(['id' => Yii::$app->user->id]);
        $link = Yii::$app->params['serviceUrls']['userUi'] . 'avatar?' . $user->dynamics_guid;

        return $this->create_img_html($link);
    }
}
