<?php

namespace onespace\widgets\ui;

use onespace\widgets\ui\base\PanelBase;

/**
 * Widget for generating a general page outline and container divs.
 * 
 * @author  Gareth Palmer <gareth@one-space.co.za>
 */

class Page extends PanelBase {

    /**
     * The elements to put onto the page. Parse html, widgets, $this->render or even just a plain string.
     * 
     * @var array   $elements
     */

    public array $elements;

    /**
     * @inheritdoc
     * 
     * @return  string
     */

    public function run(): string {
        $page = parent::run();

        $page .= $this->set_main_div('ui-page');

        if (isset($this->elements)) {
            foreach ($this->elements as $element) {
                $page .= $element;
            }
        }

        $page .= "</div>"; // ui-page

        return $page;
    }
}
