<?php

namespace onespace\widgets\icons;

use onespace\widgets\icons\base\Icon;

/**
 * Generate FontAwesome library icons as a widget.
 * 
 * The use of this widget presupposes the existance of the FA5 assets in the web directory.
 * 
 * @author  Jason Phillips <Jason@one-space.co.za>
 */

class FontAwesomeIcon extends Icon {
    protected $baseClass = ' fa-';
    protected $defaultIdentifier = 'question';

    public $styles = [
        'solid' => 'fas',
        'regular' => 'far',
        'brand' => 'fab',
        'light' => 'fal',
    ];

    public $style;

    public function init() {
        if ($this->style == null || !isset($this->styles[$this->style])) {
            $this->style = 'solid';
        }
        $this->baseClass = $this->styles[$this->style] . $this->baseClass;

        parent::init();
    }
}
