<?php

namespace onespace\widgets\ui\panels;

use onespace\widgets\ui\base\PanelBase;

/**
 * Draws out the sub page element the "Main Panel" Which is a single column panel into which
 * the contents of the page should be rendered. Handles the styling etc automatically.
 * 
 * @author  Gareth Palmer <gareth@one-space.co.za>
 */

class MainPanel extends PanelBase {

    /**
     * The contents of the panel to render. Parse html, widgets, $this->render or even just a plain string.
     * May be not parsed for an empty panel.
     * 
     * @var string|array  $content
     * 
     * @readonly
     * @access  public
     */

    public string|array $content;


    /**
     * @inheritdoc
     * 
     * @return  string
     */

    public function run(): string {
        $panel = parent::run();

        $panel .= $this->set_main_div('ui-panel');

        if (isset($this->content)) {
            if (is_array($this->content)) {
                $panel .= implode('', $this->content);
            } else {
                $panel .= $this->content;
            }
        }

        $panel .= "</div>"; // ui-panel

        return $panel;
    }
}
