<?php

namespace onespace\widgets\ui\base;

use yii\base\Widget;

/**
 * Forms the bases of image generating widgets.
 * 
 * @author  Gareth Palmer <gareth@one-space.co.za>
 */
class ImgBase extends Widget {

    /**
     * Any `<img>` element properties to add to the `<img>` tag.
     * 
     * For example `options' => ['class' => 'myClass']` will add a class of `myClass` to
     * the `<img>` tag.
     * 
     * @var array   $options    Default: []
     * 
     * @access  public
     */

    public array $options = [];

    /**
     * Explicitly state the loading method for the `<img>`.
     * 
     * @var string  $loading    Default: lazy.
     * 
     * @access  public
     */

    public string $loading = 'lazy';

    /**
     * If you wish to wrap the image in a link, pass the desired parameters
     * for the `<a>` tag here. If empty, a link will not be created.
     * 
     * @var array   $link
     * 
     * @access  public
     */

    public array $link;


    /**
     * Return the HTML for the requested image, with a <a> link if
     * desired, according to the parsed parameters & properties.
     * 
     * @param   string  $link   The link to the image.
     * 
     * @return  string
     * 
     * @access  protected
     */

    protected function create_img_html(string $link): string {
        $img = '';

        if (isset($this->link)) {
            $img .= "<a";
            foreach ($this->link as $key => $val) {
                $img .= " {$key}='{$val}'";
            }
            $img .= ">";
        }

        $img .= "<img src='{$link}' loading='{$this->loading}'";

        $options = implode(' ', array_map(function ($value, $key): string {
            return "{$key}='{$value}'";
        }, $this->options, array_keys($this->options)));
        if ($options !== '') {
            $img .= ' ' . $options;
        }

        $img .= ">";

        if (isset($this->link)) {
            $img .= "</a>";
        }
        return $img;
    }
}
