<?php

namespace onespace\widgets\ui\banner;

use onespace\widgets\ui\banner\BannerTemplate;
use onespace\widgets\ui\base\TopBanner;

/**
 * Draw the top narrow banner. It contains user's personal information with narrow margins.
 */

final class TopNarrowBanner extends TopBanner implements BannerTemplate {

    /**
     * @inheritdoc
     */

    public function run(): string {
        $bar = parent::run();
        $bar .= ' ui-panel general-narrow-banner';
        if (isset($this->container_class)) {
            $bar .= " {$this->container_class}";
        }
        $bar .= " no-header'>";
        $bar .= $this->profile_pic_big();
        $bar .= $this->user_info();
        $bar .= "</div>"; // ui-userinfo-container
        return $bar;
    }


    /**
     * @inheritdoc
     */

    public function banner_css(): string {
        return $this->minify_css(<<<CSS
        .general-narrow-banner {
            display: grid;
            padding: 1rem 3.5rem;
            align-items: center;
            grid-template-columns: 140px 1fr;
            grid-template-rows: auto;
            grid-template-areas:
                "profile-pic user-text";
        }

        .profile-pic {
            grid-area: profile-pic;
            justify-self: start;
        }
        
        .profile-pic-img {
            border: 3px solid var(--main-accent);
            border-radius: 50%;
            height: 120px;
            width: 120px;
        }

        .profile-info {
            grid-area: user-text;
            color: var(--cool-grey);
        }

        .profile-info .h3 {
            color: var(--main-accent);
            margin-top: 0;
            margin-bottom: 0;
        }

        .profile-info .h3 {
            color: var(--main-accent);
            margin-top: 0;
            margin-bottom: 0;
        }

        .profile-link {
            color: var(--cool-grey);
            font-size: 1.8rem;
        }

        .profile-link:hover {
            color: #fff;
        }

        .profile-info-sub div {
            margin-top: 3px;
        }
        CSS);
    }
}
