<?php

namespace onespace\widgets\ui\banner;

use onespace\widgets\ui\banner\BannerTemplate;
use onespace\widgets\ui\base\Align;
use onespace\widgets\ui\base\TopBanner;

final class TopHeaderBanner extends TopBanner implements BannerTemplate {

    /**
     * The text title to place into the header
     * 
     * @var string  $title
     * 
     * @access  public
     */

    public string $title;

    /**
     * The alignment of the parsed title.
     * 
     * @var Align   $title_align    Default: Align::LEFT
     * 
     * @access  public
     */

    public Align $title_align = Align::LEFT;

    /**
     * Any links to place in a top narrow banner.
     * 
     * @var array   $links
     * 
     * @access  public
     */

    public array $links;

    /**
     * The alignment of the parsed links.
     * 
     * @var Align   $links_align    Default: Align::RIGHT
     * 
     * @access  public
     */

    public Align $links_align = Align::RIGHT;


    /**
     * @inheritdoc
     */

    public function run(): string {
        $bar = parent::run();
        if (isset($this->container_class)) {
            $bar .= " {$this->container_class}";
        }
        $bar .= " title-banner narrow-banner'>";
        if (isset($this->title)) {
            $bar .= "<div class='ui-text-header {$this->title_align->get_class()}'>{$this->title}</div>";
        }

        if (isset($this->links)) {
            foreach ($this->links as &$link) {
                $link = "<span>{$link}</span>";
            }
            $links = implode('', $this->links);
            $bar .= "<div class='ui-text-links {$this->links_align->get_class()}'>{$links}</div>";
        }

        $bar .= "</div>"; // container
        return $bar;
    }


    /**
     * @inheritdoc
     */

    public function banner_css(): string {
        return $this->minify_css(<<<CSS
        .narrow-banner {
            height: max-content;
        }

        .title-banner {
            border-top-left-radius: var(--panel-border-radius);
            border-top-right-radius: var(--panel-border-radius);
            padding: 0.5rem;
            display: grid;
            grid-template-columns: max-content 1fr;
            align-items: center;
            padding-left: 3.1rem;
            padding-right: 3.1rem;
        }

        .ui-text-header {
            font-size: 4.2rem;
            font-weight: 800;
        }

        .ui-text-links {
            color: var(--main-accent);
            font-size: 3.5rem;
        }

        .ui-text-links span {
            margin-left: 0.5rem;
        }

        .ui-text-links span a {
            color: var(--main-accent);
            text-decoration: none;
        }
        CSS);
    }
}
