<?php

namespace onespace\widgets\assets;

/**
 * Returns the view object.
 * 
 * @method  public object getCurrentView() Returns the view in a non static method context.
 * @method  public static object getPageView() Returns Gets the view in a static method context.
 */

trait GetView {

    /**
     * Return the current view. Used in non static methods or below.
     */

    public function getCurrentView(): object {
        return $this->getView();
    }


    /**
     * Returns the view of the current page. Used in a static method context.
     */

    public static function getPageView(): object {
        $class_name = __CLASS__;
        $view_class = new $class_name;
        return $view_class->getCurrentView();
    }
}
