/**
 * @author  Gareth Palmer
 */

const ELEMENT_ID = 2

const left = document.getElementById(`${id}-left`).children[ELEMENT_ID];
const right = document.getElementById(`${id}-right`).children[ELEMENT_ID];

const left_values = JSON.parse(document.getElementById(`${id}_values_left`).value);
const right_values = JSON.parse(document.getElementById(`${id}_values_right`).value);

const to_right = document.getElementById(`${id}-to-right`);
const to_right_all = document.getElementById(`${id}-to-right-all`);
const to_left = document.getElementById(`${id}-to-left`);
const to_left_all = document.getElementById(`${id}-to-left-all`);

to_right.addEventListener("click", function (event) {
    event.preventDefault()
    const list = [];
    for (const option of left) {
        if (option.selected) {
            list.push(option);
        }
    }
    move_options_to(right, list, true);
});
to_right_all.addEventListener("click", function (event) {
    event.preventDefault()
    const list = [];
    for (const option of left) {
        if (option.classList.value.includes('hidden')) {
            continue;
        }
        list.push(option);
    }
    move_options_to(right, list, true);
});
to_left.addEventListener("click", function (event) {
    event.preventDefault()
    const list = [];
    for (const option of right) {
        if (option.selected) {
            list.push(option);
        }
    }
    move_options_to(left, list, false);
});
to_left_all.addEventListener("click", function (event) {
    event.preventDefault()
    const list = [];
    for (const option of right) {
        if (option.classList.value.includes('hidden')) {
            continue;
        }
        list.push(option);
    }
    move_options_to(left, list, false);
});


/**
 * Move each selected item left or right
 * 
 * @param {object} to `<select>` DOM object
 * @param {array} elements The elements to move.
 * @param {bool} ltr left to right (true) or right to left (false)
 */

function move_options_to(to, elements, ltr) {
    elements.forEach(item => {
        to.add(item);
        if (ltr) {
            right_values.push(parseInt(item.value));
            left_values.splice(left_values.indexOf(parseInt(item.value)), 1);
        } else {
            left_values.push(parseInt(item.value));
            right_values.splice(right_values.indexOf(parseInt(item.value)), 1);
        }
    });
    document.getElementById(`${id}_values_left`).value = JSON.stringify(left_values);
    document.getElementById(`${id}_values_right`).value = JSON.stringify(right_values);

    perform_sort(to);
}

function perform_sort(column) {
    const options = Array.from(column);
    options.sort(function (a, b) {
        if (a.innerHTML > b.innerHTML) {
            return 1;
        } else {
            return -1;
        }
    });

    while (column.options.length > 0) {
        column.remove(0);
    }
    options.forEach(option => {
        column.add(option);
    });
}

const filters = document.querySelectorAll('.filter-lr');
filters.forEach(filter => {
    filter.addEventListener("keyup", function () {
        perform_filter(this.parentNode.parentNode.children[ELEMENT_ID], this.value);
    });
});

function perform_filter(column, filter) {
    const options = Array.from(column);
    if (filter.trim() == "") {
        options.forEach(option => {
            option.classList.remove('hidden');
        });
    } else {
        options.forEach(option => {
            const value = option.innerHTML;
            if (value.toLowerCase().includes(filter.toLowerCase())) {
                option.classList.remove('hidden');
            } else {
                option.classList.add('hidden');
            }
        });
    }
}