<?php

/**
 * @author  Gareth Palmer
 */

namespace onespace\tools\widgets\input;

use Yii;
use yii\helpers\Html;
use yii\widgets\InputWidget;

/**
 * ## Custom attributes used by this widget
 * 
 * @property    array   $leftColumn   Default: []
 * @property    array   $rightColumn  Default: []
 * @property    string  $leftHeading  Default: `&nbsp;`
 * @property    string  $rightHeading Default: `&nbsp;`
 * @property    boolean $filter       Default: false
 * @property    array   $options
 */
final class DuelListBox extends InputWidget {

    public array $leftColumn = [];
    public array $rightColumn = [];

    public string $leftHeading = '&nbsp;';
    public string $rightHeading = '&nbsp;';

    public bool $filter = false;

    /**
     * @inheritdoc
     */
    public $options;

    private $options_left = [];
    private $options_right = [];

    public function run() {
        $this->options['multiple'] = true;
        $this->options['aria-required'] = false;

        if (!isset($this->options['size'])) {
            $this->options['size'] = 15;
        }

        $name = explode('-', $this->options['id']);

        // Set the default values
        $this->options_left = $this->options_right = $this->options;

        $this->options_left['id'] .= '-left';
        $this->options_right['id'] .= '-right';

        $this->options_left['name'] = "{$name[0]}[{$name[1]}][left][selected][]";
        $this->options_right['name'] = "{$name[0]}[{$name[1]}][right][selected][]";

        if ($this->hasModel()) {
            $left = Html::activeListBox($this->model, $this->attribute, $this->leftColumn, $this->options_left);
            $right = Html::activeListBox($this->model, $this->attribute, $this->rightColumn, $this->options_right);
        } else {
            $left = Html::listBox($this->model, $this->attribute, $this->leftColumn, $this->options_left);
            $right = Html::listBox($this->model, $this->attribute, $this->rightColumn, $this->options_right);
        }

        $random_id = str_replace('-', '_', 'dlb' . Yii::$app->security->generateRandomString(12));

        $l_hidden = Html::hiddenInput(
            "{$this->model->formName()}[{$this->attribute}][left]",
            json_encode(array_keys($this->leftColumn)),
            [
                'id' => $random_id . '_values_left',
            ]
        );
        $r_hidden = Html::hiddenInput(
            "{$this->model->formName()}[{$this->attribute}][right]",
            json_encode(array_keys($this->rightColumn)),
            [
                'id' => $random_id . '_values_right',
            ]
        );

        $view = $this->getView();
        $view->registerJs("const id = '{$random_id}'");
        $view->registerJs(file_get_contents(__DIR__ . '/js/DuelListBox.js'));

        $filter = '';
        if ($this->filter) {
            $filter = "<input class='form-control filter filter-lr' type='text' placeholder='Filter'>";
        }

        $html = "<div class='row'>
<style>
    .btn-lr {
        width: 49%;
        margin-bottom: 0.3rem;
    }

    .filter-lr {
        margin-bottom: 0.3rem;
    }
</style>
    <div id='{$random_id}-left' class='col-sm-6'>
        <div>
            <div class='text-center'>
                <h5>{$this->leftHeading}</h5>
            </div>
            {$filter}
            <button id='{$random_id}-to-right-all' class='btn btn-primary btn-lr'>&gt;&gt;</button>
            <button id='{$random_id}-to-right' class='btn btn-primary btn-lr'>&gt;</button>
        </div>
        {$left}
        {$l_hidden}
    </div>
    <div id='{$random_id}-right' class='col-sm-6'>
        <div>
            <div class='text-center'>
                <h5>{$this->rightHeading}</h5>
            </div>
            {$filter}
            <button id='{$random_id}-to-left' class='btn btn-primary btn-lr'>&lt;</button>
            <button id='{$random_id}-to-left-all' class='btn btn-primary btn-lr'>&lt;&lt;</button>
        </div>
        {$right}
        {$r_hidden}
    </div>
</div>
";

        return $html;
    }
}
