<?php

namespace onespace\tools\helpers\model;

/**
 * Perform standard bitwise operations.
 */

trait BitwiseHelperTrait {

    /**
     * Perform a bitwise AND to an integer property to see if the parsed
     * value is present on that integer.
     * 
     * @param   string  $property   Property within the object which may or may
     *                              not contain the value being searched for.
     * @param   int     $value      The value being searched for on the `$property`
     * 
     * @return  bool
     * 
     * @access  public
     */

    public function bitwiseHasValue(string $property, int $value): bool {
        return $this->$property & $value;
    }


    /**
     * Perform a bitwise operation to add a specified value to an integer property.
     * 
     * @param   string  $property   Property within the object which may or may
     *                              not contain the value being added.
     * @param   int     $value      The value being added on the `$property`
     * 
     * @access  public
     */

    public function bitwiseAddValue(string $property, int $value): void {
        $this->$property |= $value;
    }


    /**
     * Perform a bitwise operation to remove a specified value from an integer property.
     * 
     * @param   string  $property   Property within the object which may or may
     *                              not contain the value being removed.
     * @param   int     $value      The value being removed on the `$property`
     * 
     * @access  public
     */

    public function bitwiseRemoveValue(string $property, int $value): void {
        $this->$property &= ~$value;
    }
}
