<?php

namespace onespace\tools\assets;

use yii\web\AssetBundle;

/**
 * You will need to link this to your `assets/AppAsset.php` file.
 * 
 * 
 * ## Requirement
 * 
 * You will need to add the this to the Yii AppAssets file.
 * 
 * ```php
 * class AppAsset extends AssetBundle
 * {
 *    ... 
 *    public $depends = [
 *         'yii\web\YiiAsset',
 *         ...
 *         'onespace\tools\web\TinyMCEAsset',
 *     ];
 * }
 * ```
 */

class TinyMCEAsset extends AssetBundle {
    public $sourcePath = '@vendor/tinymce/tinymce';

    public $js = [
        'tinymce.min.js',
    ];

}