<?php

namespace onespace\tools\assets;

use yii\web\AssetBundle;
use yii\web\View;

/**
 * Main application asset bundle.
 *
 * @author Qiang Xue <qiang.xue@gmail.com>
 * @since 2.0
 */
class MapAsset extends AssetBundle {
    public $sourcePath = __DIR__;
    // public $basePath = '@webroot';
    // public $baseUrl = '@web';
    public $css = [];
    public $js = [
        [
            'js/startMap.js',
            'position' => View::POS_HEAD
        ],
        [
            'https://cdnjs.cloudflare.com/ajax/libs/OverlappingMarkerSpiderfier/1.0.3/oms.min.js',
            'position' => View::POS_BEGIN
        ],

    ];
    public $depends = [];

    /**
     * {@inheritdoc}
     */
    public function init() {
        // Append skin color file if specified
        $this->js[] = [
            'https://maps.google.com/maps/api/js?key=' . getenv('GOOGLE_MAPS_API_KEY') . '&libraries=drawing,visualization,places&callback=startMap',
            // adding loading=async is the new way of doing things, but currently it causes errors, with parts of the library not loaded when being loaded
            // via php. Thus removed for the moment
            // 'https://maps.google.com/maps/api/js?key=' . getenv('GOOGLE_MAPS_API_KEY') . '&libraries=drawing,visualization,places&callback=startMap&loading=async',
            'position' => View::POS_BEGIN
        ];

        parent::init();
    }
}
