<?php

namespace onespace\tools\widgets\input;

use Exception;
use yii\helpers\ArrayHelper;
use yii\helpers\Html;
use yii\widgets\InputWidget;

/**
 * {@inheritdoc}
 * 
 * @author  Gareth Palmer <gareth@one-space.co.za>
 */

final class DuelDateSelector extends InputWidget {

    /**
     * OPTIONAL. The left input attribute when the model is set. If not
     * parsed, it will be automatically set from `$this->atribute`.
     * 
     * @var string  $leftAttribute
     * 
     * @access  public
     */

    public string $leftAttribute;

    /**
     * REQUIRED IF MODEL. The right input attribute when the model is set.
     * If not parsed, an Exception will be thrown.
     * 
     * @var string  $rightAttribute
     * 
     * @access  public
     */

    public string $rightAttribute;

    /**
     * OPTIONAL. The left `name` attribute when no model is set. If not
     * parsed, it will be automatically set from `$this->name`.
     * 
     * @var string  $leftName
     * 
     * @access  public
     */

    public string $leftName;

    /**
     * REQUIRED IF NO MODEL. The right `name attribute when no model is set.
     * If not poarsed, an `Exception` will be thrown.
     * 
     * @var string  $rightName
     * 
     * @access  public
     */

    public string $rightName;

    /**
     * OPTIONAL. Any additional options to add to the left hand `<input>` element.
     * It will be merged with `$this->options` and `$this->options should be used
     * for any common options. Anything in `$this->leftOptions` will overwrite any
     * conflicts with `$this->options`.
     * 
     * @var array   $leftOptions    Default: []
     * 
     * @access  public
     */

    public array $leftOptions = [];

    /**
     * OPTIONAL. Any additional options to add to the left hand `<input>` element.
     * It will be merged with `$this->options` and `$this->options should be used
     * for any common options. Anything in `$this->rightOptions` will overwrite any
     * conflicts with `$this->options`.
     * 
     * @var array   $rightOptions   Default: []
     * 
     * @access  public
     */

    public array $rightOptions = [];

    /**
     * OPTIONAL. If not model, set a value for the left hand `<input>` element. If not
     * set, this will be set to `$this->value`.
     * 
     * @var string  $leftValue
     * 
     * @access  public
     */

    public string $leftValue;

    /**
     * OPTIONAL. If not model, set a value for the right hand `<input>` element.
     * 
     * @var string  $rightValue
     * 
     * @access  public
     */

    public string $rightValue;


    /**
     * {@inheritdoc}
     * 
     * @throws  Exception   If not right hand `attribute` or `name` is set.
     * 
     * @access  public
     */

    public function init() {
        parent::init();

        $this->leftOptions['data-duel-date'] = 'left';
        $this->rightOptions['data-duel-date'] = 'right';

        if ($this->hasModel()) {
            $hold = explode(' ', $this->options['class']);
            array_splice($hold, 1, 0, 'col-sm-5-dd');
            $this->options['class'] = implode(' ', $hold);
        } else {
            $hold = '';
            if (isset($this->options['class'])) {
                $hold = " {$this->options['class']}";
            }
            $this->options['class'] = "col-sm-6{$hold}";
        }

        $this->leftOptions = ArrayHelper::merge($this->options, $this->leftOptions);
        $this->rightOptions = ArrayHelper::merge($this->options, $this->rightOptions);

        $this->leftOptions['class'] .= ' pull-left';
        $this->rightOptions['class'] .= ' pull-right';

        if ($this->hasModel()) {
            $this->leftAttribute ??= $this->attribute;
            if (!isset($this->rightAttribute)) {
                throw new Exception("You must set the right hand attribute (rightAttribute)");
            }

            $la = $this->leftAttribute;
            $ra = $this->rightAttribute;

            // Remove the time attribute.
            $this->model->$la = explode(' ', $this->model->$la ?? '')[0];
            $this->model->$ra = explode(' ', $this->model->$ra ?? '')[0];
        } else {
            $this->rightName ??= $this->name;
            if (!isset($this->rightName)) {
                throw new Exception("You must set the right hand name (rightName)");
            }
            $this->leftValue ??= $this->value;
            $this->rightValue ??= null;
        }

        $view = $this->getView();
        $view->registerJs(file_get_contents(__DIR__ . '/js/DuelDateSelector.js'));
        $view->registerCss(file_get_contents(__DIR__ . '/css/DuelDateSelector.css'));
    }


    /**
     * {@inheritdoc}
     * 
     * @return  string
     * 
     * @access  public
     */

    public function run(): string {
        parent::run();
        $inputs = '';
        $inputs .= Html::beginTag('div', ['class' => 'row dd-row']);
        if ($this->hasModel()) {
            $inputs .= Html::activeInput('date', $this->model, $this->leftAttribute, $this->leftOptions); // left
            $inputs .= Html::activeInput('date', $this->model, $this->rightAttribute, $this->rightOptions); // right
        } else {
            $inputs .= Html::input('date', $this->leftName, $this->leftValue, $this->leftOptions); // left
            $inputs .= Html::input('date', $this->rightName, $this->rightValue, $this->rightOptions); // right
        }
        $inputs .= Html::endTag('div');
        return $inputs;
    }
}
