<?php

namespace onespace\tools\widgets\icons;

use onespace\tools\widgets\icons\base\FAHelper;
use onespace\tools\widgets\icons\base\Icon;
use onespace\tools\widgets\icons\OSIcon;


/**
 * Generate FontAwesome 6 library icons as a widget.
 * 
 * To use this widget, you need to register `\onespace\tools\assets\FontAwesome6Asset::class` in `AppAssets`.
 * 
 * @property    string|null $identifier See `https://fontawesome.com/icons`
 * @property    string|null $style
 * ## Valid Style Options
 * - solid
 * - regular
 * - light
 * - duotone
 * - thin
 * - brand (Only available for a small number of icons)
 * @property    string|null $colour
 * ## Valid Colour Options
 * - light-blue
 * - aqua
 * - green
 * - yellow
 * - red
 * - gray
 * - navy
 * - teal
 * - purple
 * - orange
 * - maroon
 * - black
 * @property    string  $content    Default: `&nbsp;`
 * 
 * @author  Gareth Palmer   <gareth@one-space.co.za>
 * @deprecated  2024-08-23 - Moved to onespace\tools\icons\_rest_of_namespace_
 */

final class FontAwesomeIcon6 extends Icon {

    use FAHelper {
        init as FAInit;
    }

    /**
     * If desired, the icon can be set from the `OSIcon` enum, containing
     * a list of generally defined icons used by the various OneSpace systems.
     * 
     * @var onespace\tools\widgets\icons\OSIcon $icon
     * 
     * @access  public
     */

    public OSIcon $icon;

    protected const STYLES = [
        'solid'   => 'fa-solid',
        'regular' => 'fa-regular',
        'light'   => 'fa-light',
        'duotone' => 'fa-duotone',
        'thin'    => 'fa-thin',
        'brand'   => 'fa-brands'
    ];


    /**
     * {@inheritdoc}
     */

    public function init() {
        if (isset($this->icon)) {
            $this->identifier = $this->icon->id();
        }
        $this->FAInit();
    }
}
