<?php

/**
 * # REQUIRED ENV VARIABLES
 * 
 * The following variables are required to be set in your .env file.
 * 
 * - TDENGINE_LINK
 * - TDENGINE_DB
 * - TDENGINE_USERNAME
 * - TDENGINE_PASSWORD
 */

$link = getenv('TDENGINE_LINK');
$database = getenv('TDENGINE_DB');

return [
    'class' => onespace\tools\components\tdengine\Connection::class,
    'dsn' => "taos:host={$link};dbname={$database}",
    'username' => getenv('TDENGINE_USERNAME') ?? 'root',
    'password' => getenv('TDENGINE_PASSWORD'),
];