<?php

namespace onespace\tools\helpers\enum;

/**
 * Enum of valid HTTP methods.
 * 
 * @see https://dev-wiki.1s.co.za/books/helpers/page/httpmethod
 * 
 * @deprecated  Moved to it's own library
 */
enum HTTPMethod {
    case GET;
    case POST;
    case PUT;
    case PATCH;
    case DELETE;
    case HEAD;
    case OPTIONS;


    public function value(): string {
        return match ($this) {
            self::GET     => 'get',
            self::POST    => 'post',
            self::PUT     => 'put',
            self::PATCH   => 'patch',
            self::DELETE  => 'delete',
            self::HEAD    => 'head',
            self::OPTIONS => 'options',
        };
    }
}
