<?php

namespace onespace\tools\components\tdengine;

class ActiveQuery extends \yii\db\ActiveQuery {

    /**
     * Creates a DB command that can be used to execute this query.
     * @param Connection|null $db the DB connection used to create the DB command.
     * If `null`, the DB connection returned by [[modelClass]] will be used.
     * @return Command the created DB command instance.
     */
    public function createCommand($adb = null) {
        /* @var $modelClass ActiveRecord */
        $modelClass = $this->modelClass;
        if ($adb === null) {
            $adb = $modelClass::getDb();
        }

        return parent::createCommand($adb);
    }


    /**
     * {@inheritdoc}
     */
    public function prepare($builder) {
        if (is_string($this->from)) {
            $this->from = [$this->from];
        }
        return parent::prepare($builder);
    }
}
