<?php

namespace onespace\tutorial\models;

/**
 * This is the model class for table "tutorial_user".
 *
 * @property int $id
 * @property string $user_id
 * @property string $page_path
 * @property string $update_version
 */
class TutorialUser extends \yii\db\ActiveRecord
{

    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'tutorial_user';
    }

    public function behaviors()
    {
        return parent::behaviors();
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id'], 'integer'],
            [['page_path'], 'string', 'max' => 512],
            [['update_version'], 'string', 'max' => 128],
            [['user_id'], 'string', 'max' => 50],
            [['page_path', 'user_id'], 'required']
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'id',
            'user_id' => 'user_id',
            'page_path' => 'page_path',
            'update_version' => 'update_version',
        ];
    }
    
    /**
     * @inheritdoc
     * @return \onespace\tutorial\models\query\TutorialUserQuery the active query used by this AR class.
     */
    public static function find()
    {
        return new \onespace\tutorial\models\query\TutorialUserQuery(get_called_class());
    }
}

