<?php

namespace onespace\tutorial\models;

/**
 * This is the model class for table "tutorial".
 *
 * @property int $id
 * @property string $page_path
 * @property string $update_version
 * @property int $order
 * @property string $highlight_element
 * @property string $title
 * @property string $content
 * @property string $side
 * @property string $align
 */
class Tutorial extends \yii\db\ActiveRecord
{

    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'tutorial';
    }

    public function behaviors()
    {
        return parent::behaviors();
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'order'], 'integer'],
            [['page_path', 'highlight_element', 'title'], 'string', 'max' => 512],
            [['update_version'], 'string', 'max' => 128],
            [['side', 'align'], 'string', 'max' => 25],
            [['content'], 'string'],
            [['page_path', 'order', 'content'], 'required']
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'id',
            'page_path' => 'Page Path',
            'update_version' => 'Update Version',
            'order' => 'Order',
            'highlight_element' => 'Highlight Element',
            'title' => 'Title',
            'content' => 'Content',
            'side' => 'Side',
            'align' => 'Align',
        ];
    }
    
    /**
     * @inheritdoc
     * @return \onespace\tutorial\models\query\TutorialQuery the active query used by this AR class.
     */
    public static function find()
    {
        return new \onespace\tutorial\models\query\TutorialQuery(get_called_class());
    }
}

