<?php

namespace onespace\tutorial\widgets;

use onespace\tutorial\assets\DriverJsAsset;
use Yii;
use yii\base\Widget;
use yii\web\View;

/**
 * This widget is used to generate DriverJs items
 * 
 * @see https://driverjs.com/docs/basic-usage
 * 
 * @author  Jason Phillips <jason@one-space.co.za>
 */
class DriverWidget extends Widget {

    /**
     * {@inheritdoc}
     */

     public function init(): void {
        parent::init();

        $view = $this->getView();
        $view->registerAssetBundle(DriverJsAsset::class, View::POS_HEAD);
    }


    /**
     * {@inheritdoc}
     * 
     * @return  string
     */

     public function run(): string {
        return $this->button;
    }
}