<?php

namespace onespace\tutorial\migrations;

use Yii;
use yii\db\Migration;

/**
 * Class m150000_000002_add_permissions
 */
class m150000_000002_add_permissions extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $auth = Yii::$app->authManager;

        $tutorialViewPerm = $auth->createPermission('tutorial.view');
        $tutorialViewPerm->description = 'View tutorials';
        $auth->add($tutorialViewPerm);
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $auth = Yii::$app->authManager;

        $tutorialViewPerm = $auth->getPermission('tutorial.view');
        $auth->remove($tutorialViewPerm);
    }

    /*
    // Use up()/down() to run migration code without a transaction.
    public function up()
    {

    }

    public function down()
    {
        echo "m241125_121826_populate_feedback_types cannot be reverted.\n";

        return false;
    }
    */
}
